/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.subscenario;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.model.helpers.AbstractCapabilityPkgExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.LogicalComponentExt;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.utils.ListExt;
import org.polarsys.capella.core.refinement.framework.ui.IValidator;
import org.polarsys.capella.core.refinement.framework.ui.SelectionPage;
import org.polarsys.capella.core.refinement.framework.ui.SelectionWizard;
import org.polarsys.capella.core.refinement.framework.ui.model.SelectionItemNode;
import org.polarsys.capella.core.refinement.framework.ui.model.TargetSelectionItem;
import org.polarsys.capella.core.refinement.scenarios.core.ScenarioRefinement;
import org.polarsys.capella.core.refinement.subscenario.Messages;
import org.polarsys.capella.core.refinement.subscenario.SubScenarioRefinement;

public class SubScenarioUtils {
    public static void addNewSubScenario(final Scenario currentScenario, IProgressMonitor progressMonitor) {
        if (currentScenario != null) {
            Logger _logger = ReportManagerRegistry.getInstance().subscribe("Refinement");
            List<NamedElement> targets = SubScenarioUtils.evaluateTarget(currentScenario);
            if (!targets.isEmpty()) {
                String message = Messages.getString("SubScenarioUtils.0");
                TargetSelectionItem rootItem = new TargetSelectionItem((NamedElement)currentScenario, targets);
                SelectionWizard wizard = new SelectionWizard((SelectionItemNode)rootItem, Messages.getString("SubScenarioUtils.1"), Messages.getString("SubScenarioUtils.2"), message, true, false, true, Messages.getString("SubScenarioUtils.3"), false);
                wizard.addValidator(new IValidator(){

                    public boolean isValid(SelectionPage page) {
                        boolean result = true;
                        for (SelectionItemNode item : page.getSelection()) {
                            Object obj = item.getData();
                            if (!(obj instanceof CapellaElement)) continue;
                            AbstractCapability capability = (AbstractCapability)currentScenario.eContainer();
                            for (CapellaElement elt : RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)capability, (EClass)InteractionPackage.Literals.ABSTRACT_CAPABILITY)) {
                                if (!EcoreUtil2.isContainedBy((EObject)elt, (EObject)((CapellaElement)obj))) continue;
                                String realName = ScenarioRefinement.evaluateNamingRule((NamedElement)((NamedElement)obj), (String)page.getNameValue());
                                AbstractCapability subInteractionAspect = (AbstractCapability)elt;
                                if (ListExt.filterByName(new ArrayList(subInteractionAspect.getOwnedScenarios()), (String)realName).isEmpty()) continue;
                                result = false;
                            }
                        }
                        return result;
                    }

                    public String getMessage() {
                        return Messages.getString("SubScenarioUtils.10");
                    }
                });
                if (wizard.open() == 0) {
                    String scenarioName = wizard.getNameValue();
                    for (SelectionItemNode item : wizard.getSelectionList()) {
                        SubScenarioRefinement ref = null;
                        NamedElement target = (NamedElement)item.getData();
                        if (target instanceof ComponentArchitecture) {
                            ref = new SubScenarioRefinement(currentScenario, (ComponentArchitecture)target, scenarioName);
                        } else if (target instanceof Component) {
                            ref = new SubScenarioRefinement(currentScenario, (Component)target, scenarioName);
                        }
                        if (ref == null) continue;
                        ref.execute(progressMonitor);
                        _logger.info((Object)new EmbeddedMessage(MessageFormat.format(Messages.getString("SubScenarioUtils.13"), scenarioName), "Refinement", ref.getResult()));
                    }
                }
            } else {
                _logger.info((Object)new EmbeddedMessage(Messages.getString("SubScenarioUtils.11"), "Refinement", (Object)currentScenario));
            }
        }
    }

    public static void addExistingSubScenario(Scenario currentScenario, IProgressMonitor progressMonitor) {
        if (currentScenario != null) {
            Logger _logger = ReportManagerRegistry.getInstance().subscribe("Refinement");
            Map<NamedElement, List<NamedElement>> targets = SubScenarioUtils.evaluateTargets(currentScenario);
            if (!targets.isEmpty()) {
                String message = Messages.getString("SubScenarioUtils.4");
                TargetSelectionItem rootItem = new TargetSelectionItem(targets);
                SelectionWizard wizard = new SelectionWizard((SelectionItemNode)rootItem, Messages.getString("SubScenarioUtils.1"), Messages.getString("SubScenarioUtils.6"), message, true, true);
                if (wizard.open() == 0) {
                    for (SelectionItemNode item : wizard.getSelectionList()) {
                        Scenario sc = (Scenario)item.getData();
                        if (sc == null) continue;
                        SubScenarioRefinement ref = new SubScenarioRefinement(currentScenario, sc);
                        ref.execute(progressMonitor);
                        _logger.info((Object)new EmbeddedMessage(MessageFormat.format(Messages.getString("SubScenarioUtils.14"), sc.getName()), "Refinement", (Object)sc));
                    }
                }
            } else {
                _logger.info((Object)new EmbeddedMessage(Messages.getString("SubScenarioUtils.12"), "Refinement", (Object)currentScenario));
            }
        }
    }

    private static List<NamedElement> evaluateTarget(Scenario scenario) {
        ArrayList<NamedElement> targetSet;
        block4: {
            NamedElement diagramContainer;
            block5: {
                block3: {
                    targetSet = new ArrayList<NamedElement>();
                    diagramContainer = ScenarioExt.getContainer((Scenario)scenario);
                    if (!(diagramContainer instanceof SystemEngineering)) break block3;
                    for (LogicalArchitecture la : SystemEngineeringExt.getAllLogicalArchitecture((CapellaElement)scenario)) {
                        targetSet.add((NamedElement)la);
                    }
                    break block4;
                }
                if (!(diagramContainer instanceof LogicalArchitecture)) break block5;
                LogicalComponent rootLc = SystemEngineeringExt.getRootLogicalComponent((LogicalArchitecture)((LogicalArchitecture)diagramContainer));
                for (LogicalComponent lc : LogicalComponentExt.getDecompositionLogicalComponentInvolved((LogicalComponent)rootLc)) {
                    if (!ComponentExt.isComposite((Component)lc) || !ScenarioExt.contains((Scenario)scenario, (Component)lc)) continue;
                    targetSet.add((NamedElement)lc);
                }
                break block4;
            }
            if (!(diagramContainer instanceof LogicalComponent)) break block4;
            for (LogicalComponent lc : LogicalComponentExt.getDecompositionLogicalComponentInvolved((LogicalComponent)((LogicalComponent)diagramContainer))) {
                if (!ComponentExt.isComposite((Component)lc) || !ScenarioExt.contains((Scenario)scenario, (Component)lc)) continue;
                targetSet.add((NamedElement)lc);
            }
        }
        return targetSet;
    }

    private static Map<NamedElement, List<NamedElement>> evaluateTargets(Scenario scenario) {
        HashMap<NamedElement, List<NamedElement>> result = new HashMap<NamedElement, List<NamedElement>>();
        for (NamedElement cpnt : SubScenarioUtils.evaluateTarget(scenario)) {
            ArrayList<Scenario> scenariosToBeAttached = new ArrayList<Scenario>();
            List scenarios = null;
            if (cpnt instanceof BlockArchitecture) {
                scenarios = AbstractCapabilityPkgExt.getAllScenarios((AbstractCapabilityPkg)((BlockArchitecture)cpnt).getOwnedAbstractCapabilityPkg());
            } else if (cpnt instanceof LogicalComponent) {
                scenarios = AbstractCapabilityPkgExt.getAllScenarios((AbstractCapabilityPkg)((LogicalComponent)cpnt).getOwnedAbstractCapabilityPkg());
            }
            if (scenarios == null) continue;
            for (Scenario sc : scenarios) {
                if (ScenarioExt.createdByRefinement((Scenario)sc)) continue;
                scenariosToBeAttached.add(sc);
            }
            if (scenariosToBeAttached.isEmpty()) continue;
            result.put(cpnt, scenariosToBeAttached);
        }
        return result;
    }
}

