/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.elements;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.profiler.ProfilerTask;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.sequence.Messages;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InteractionUse;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.util.EventFinder;
import org.eclipse.sirius.diagram.sequence.business.internal.util.ParentOperandFinder;
import org.eclipse.sirius.diagram.sequence.description.DescriptionPackage;
import org.eclipse.sirius.diagram.sequence.description.FrameMapping;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;

public abstract class AbstractFrame
extends AbstractSequenceNode
implements ISequenceEvent {
    private static final ProfilerTask COVERAGE = new ProfilerTask(Messages.AbstractFrame_coverageProfilerTaskCategory, Messages.AbstractFrame_coverageProfilerTaskName, "/images/viewpoint.gif");

    AbstractFrame(Node node) {
        super(node);
    }

    public static Predicate<View> notationPredicate() {
        return Predicates.or(InteractionUse.notationPredicate(), CombinedFragment.notationPredicate());
    }

    @Override
    public Rectangle getProperLogicalBounds() {
        return this.getRawNotationBounds();
    }

    public Collection<Lifeline> computeCoveredLifelines() {
        DDiagramElement dde;
        DiagramElementMapping diagramElementMapping;
        DslCommonPlugin.PROFILER.startWork(COVERAGE);
        Collection semLifelines = new ArrayList();
        ArrayList<Lifeline> coveredLifelines = new ArrayList<Lifeline>();
        EObject element = this.getNotationNode().getElement();
        if (element instanceof DDiagramElement && (diagramElementMapping = (dde = (DDiagramElement)element).getDiagramElementMapping()) instanceof FrameMapping) {
            FrameMapping mapping = (FrameMapping)diagramElementMapping;
            EObject semanticInteractionUse = dde.getTarget();
            IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)semanticInteractionUse);
            if (interpreter != null && !StringUtil.isEmpty((String)mapping.getCoveredLifelinesExpression())) {
                try {
                    semLifelines = interpreter.evaluateCollection(semanticInteractionUse, mapping.getCoveredLifelinesExpression());
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)mapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getFrameMapping_CoveredLifelinesExpression(), (Throwable)e);
                }
            }
        }
        ArrayList<Lifeline> allLifelines = new ArrayList<Lifeline>(this.getDiagram().getAllLifelines());
        for (Lifeline lifeline : allLifelines) {
            EObject sem = (EObject)ISequenceElement.SEMANTIC_TARGET.apply((Object)lifeline);
            if (!semLifelines.contains(sem)) continue;
            coveredLifelines.add(lifeline);
        }
        DslCommonPlugin.PROFILER.stopWork(COVERAGE);
        return coveredLifelines;
    }

    public Collection<ISequenceEvent> computeParentEvents() {
        Collection<Lifeline> coveredLifelines = this.computeCoveredLifelines();
        return this.computeParentEvents(coveredLifelines);
    }

    public Collection<ISequenceEvent> computeParentEvents(Collection<Lifeline> coveredLifelines) {
        HashSet<ISequenceEvent> parentEvents = new HashSet<ISequenceEvent>();
        for (Lifeline lifeline : coveredLifelines) {
            EventFinder finder = new EventFinder(lifeline);
            finder.setEventsToIgnore((Predicate<ISequenceEvent>)Predicates.equalTo((Object)this));
            Range verticalRange = this.getVerticalRange();
            ISequenceEvent localParent = finder.findMostSpecificEvent(verticalRange);
            if (localParent == null || !localParent.getVerticalRange().includes(verticalRange)) continue;
            parentEvents.add(localParent);
        }
        return parentEvents;
    }

    @Override
    public Option<Lifeline> getLifeline() {
        return Options.newNone();
    }

    @Override
    public ISequenceEvent getParentEvent() {
        return null;
    }

    @Override
    public boolean isLogicallyInstantaneous() {
        return false;
    }

    @Override
    public boolean canChildOccupy(ISequenceEvent child, Range range) {
        return false;
    }

    @Override
    public boolean canChildOccupy(ISequenceEvent child, Range range, List<ISequenceEvent> eventsToIgnore, Collection<Lifeline> lifelines) {
        return false;
    }

    @Override
    public Range getOccupiedRange() {
        return Range.emptyRange();
    }

    @Override
    public Range getValidSubEventsRange() {
        return Range.emptyRange();
    }

    @Override
    public ISequenceEvent getHierarchicalParentEvent() {
        return null;
    }

    @Override
    public Option<Operand> getParentOperand() {
        return new ParentOperandFinder(this).getParentOperand();
    }

    @Override
    public Collection<ISequenceEvent> getEventsToMoveWith() {
        return this.getSubEvents();
    }
}

