/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.style.EdgeStyleDescription;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.graphics.RGB;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.SimpleOrientedGraph;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.commands.preferences.service.ScopedCapellaPreferencesStore;
import org.polarsys.capella.core.commands.preferences.util.PreferencesHelper;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.AbstractPhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.cs.PhysicalPathInvolvement;
import org.polarsys.capella.core.data.cs.PhysicalPathReference;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.information.PartitionableElement;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.pa.AbstractPhysicalComponent;
import org.polarsys.capella.core.data.pa.PaFactory;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalActor;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.deployment.DeploymentFactory;
import org.polarsys.capella.core.data.pa.deployment.PartDeploymentLink;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.model.helpers.PhysicalComponentExt;
import org.polarsys.capella.core.model.helpers.PhysicalLinkExt;
import org.polarsys.capella.core.model.helpers.PhysicalPathExt;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.FaServices;
import org.polarsys.capella.core.sirius.analysis.ShapeUtil;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class PhysicalServices {
    private static PhysicalServices __service = null;
    private static final Integer THICK_EDGE_PHYSICAL_PATH = 4;
    private static final String INCOMPLETE_PHYSICAL_PATH_LABEL = "incomplete";
    private static final String INVALID_PHYSICAL_PATH_LABEL = "invalid";

    public static PhysicalServices getService() {
        if (__service == null) {
            __service = new PhysicalServices();
        }
        return __service;
    }

    public boolean isMultipleDeploymentAllowed() {
        return CapellaModelPreferencesPlugin.getDefault().isMultipleDeploymentAllowed();
    }

    public Collection<EObject> getPhysicalPathSources(PhysicalPath path) {
        HashSet<EObject> result = new HashSet<EObject>();
        for (PhysicalPathInvolvement anInvolvement : PhysicalPathExt.getFlatInvolvementsOf((PhysicalPath)path, (EClass)CsPackage.Literals.PHYSICAL_LINK)) {
            PhysicalLink currentExchange = (PhysicalLink)anInvolvement.getInvolved();
            if (currentExchange == null || currentExchange.eIsProxy()) continue;
            Port source = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourcePort((PhysicalLink)currentExchange);
            result.add((EObject)source);
            Port target = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPort((PhysicalLink)currentExchange);
            result.add((EObject)target);
        }
        return result;
    }

    public Collection<EObject> getPhysicalPathTargets(PhysicalPath path) {
        return this.getPhysicalPathSources(path);
    }

    public List<EObject> getAvailableComponentsToDeploy(PhysicalComponent context) {
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(PaPackage.Literals.PHYSICAL_COMPONENT, (EStructuralFeature)CsPackage.Literals.ABSTRACT_DEPLOYMENT_LINK__DEPLOYED_ELEMENT);
        return query.getAvailableElements((EObject)context);
    }

    public List<EObject> getAvailableComponentsToDeploy(Part context) {
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(CsPackage.Literals.PART, (EStructuralFeature)CsPackage.Literals.ABSTRACT_DEPLOYMENT_LINK__DEPLOYED_ELEMENT);
        return query.getAvailableElements((EObject)context);
    }

    public List<EObject> getDeployedComponents(PhysicalComponent context) {
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(PaPackage.Literals.PHYSICAL_COMPONENT, (EStructuralFeature)CsPackage.Literals.ABSTRACT_DEPLOYMENT_LINK__DEPLOYED_ELEMENT);
        return query.getCurrentElements((EObject)context, false);
    }

    public List<EObject> getDeployedComponents(Part context) {
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(CsPackage.Literals.PART, (EStructuralFeature)CsPackage.Literals.ABSTRACT_DEPLOYMENT_LINK__DEPLOYED_ELEMENT);
        return query.getCurrentElements((EObject)context, false);
    }

    public List<Part> getAvailableComponentsToDeploy(Part part, boolean behaviour) {
        ArrayList<Part> returnedList = new ArrayList<Part>();
        for (EObject anElement : this.getAvailableComponentsToDeploy(part)) {
            if (!(anElement instanceof Part)) continue;
            Part aPart = (Part)anElement;
            if ((!behaviour || !this.isBehaviour(aPart)) && (behaviour || !this.isNode(aPart))) continue;
            returnedList.add(aPart);
        }
        return returnedList;
    }

    public List<Part> getDeployedComponents(Part part, boolean behaviour) {
        ArrayList<Part> returnedList = new ArrayList<Part>();
        for (EObject anElement : this.getDeployedComponents(part)) {
            if (!(anElement instanceof Part)) continue;
            Part aPart = (Part)anElement;
            if ((!behaviour || !this.isBehaviour(aPart)) && (behaviour || !this.isNode(aPart))) continue;
            returnedList.add(aPart);
        }
        return returnedList;
    }

    public boolean isValidPPDInvolveComponent(DSemanticDecorator context) {
        return context instanceof DDiagram;
    }

    public boolean isValidPPDInvolvePart(DSemanticDecorator context) {
        return context instanceof DDiagram;
    }

    public boolean isValidPPDInvolvePhysicalPath(DSemanticDecorator context) {
        return context instanceof DDiagram;
    }

    public boolean isValidPPDInvolvePhysicalLink(EObject context, PhysicalPathInvolvement source, PhysicalPathInvolvement target) {
        return this.isAnEdgeInvolvementAvailableInPPD(context, source, target);
    }

    public boolean isValidPPDInvolvePhysicalLinkAndComponent(DSemanticDecorator context) {
        return true;
    }

    public boolean isValidPPDInvolvePhysicalLinkAndPhysicalPath(DSemanticDecorator context) {
        return context instanceof AbstractDNode;
    }

    public boolean isValidPPDInvolvePhysicalLinkAndPart(DSemanticDecorator context) {
        return true;
    }

    public Collection<PhysicalPath> getPPDInvolvePhysicalPathScope(DSemanticDecorator diagram) {
        EObject chain = diagram.getTarget();
        if (!(chain instanceof PhysicalPath)) {
            return Collections.emptyList();
        }
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)chain);
        List chains = PhysicalPathExt.getAllPhysicalPaths((BlockArchitecture)architecture);
        LinkedList<PhysicalPath> result = new LinkedList<PhysicalPath>();
        for (PhysicalPath definedChain : chains) {
            boolean toAdd = true;
            if (definedChain.equals(chain)) {
                toAdd = false;
            }
            if (toAdd) {
                for (PhysicalPathInvolvement involvement : PhysicalPathExt.getFlatInvolvementsOf((PhysicalPath)definedChain, (EClass)CsPackage.Literals.PHYSICAL_PATH)) {
                    if (!chain.equals(involvement.getInvolved())) continue;
                    toAdd = false;
                    break;
                }
            }
            if (!toAdd) continue;
            result.add(definedChain);
        }
        return result;
    }

    public Collection<Part> getPPDInvolvePartScope(DSemanticDecorator context) {
        EObject target = context.getTarget();
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
        HashSet<Part> parts = new HashSet<Part>();
        for (Part part : PartExt.getAllPartsFromPhysicalArchitecture((PhysicalArchitecture)((PhysicalArchitecture)architecture))) {
            if (!(part.getAbstractType() instanceof AbstractPhysicalComponent) || !PhysicalComponentNature.NODE.equals((Object)((AbstractPhysicalComponent)part.getAbstractType()).getNature())) continue;
            parts.add(part);
        }
        return parts;
    }

    public Collection<Component> getPPDInvolveComponentScope(DSemanticDecorator context) {
        EObject target = context.getTarget();
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
        HashSet<Component> parts = new HashSet<Component>();
        for (Part part : PartExt.getAllPartsFromBlockArch((BlockArchitecture)architecture)) {
            Component component = (Component)part.getAbstractType();
            if (component == null || PhysicalComponentExt.isPhysicalComponentRoot((EObject)component)) continue;
            parts.add(component);
        }
        return parts;
    }

    public List<PhysicalLink> getDisplayedPhysicalLinks(DNodeContainer selectedElement) {
        ArrayList<PhysicalLink> returnedList = new ArrayList<PhysicalLink>();
        ArrayList<DEdge> incomingOutgoingEdges = new ArrayList<DEdge>();
        for (DNode aNode : selectedElement.getOwnedBorderedNodes()) {
            if (!(aNode.getTarget() instanceof PhysicalPort)) continue;
            incomingOutgoingEdges.addAll(CapellaServices.getService().getIncomingEdges((EdgeTarget)aNode));
            incomingOutgoingEdges.addAll(CapellaServices.getService().getOutgoingEdges((EdgeTarget)aNode));
        }
        for (DEdge anEdge : incomingOutgoingEdges) {
            String edgeMappingName = anEdge.getMapping().getName();
            if (!(anEdge.getTarget() instanceof PhysicalLink) || edgeMappingName.equals("PAB_ComputedPhysicalLink") || edgeMappingName.equals("LAB_ComputedPhysicalLink")) continue;
            returnedList.add((PhysicalLink)anEdge.getTarget());
        }
        return returnedList;
    }

    public List<PhysicalLink> getAvailablePhysicalLinksToInsert(DNodeContainer context, DDiagram diagram) {
        ArrayList<PhysicalLink> returnedList = new ArrayList<PhysicalLink>();
        ArrayList allPhysicalLinks = new ArrayList();
        ArrayList<PhysicalLink> existingExchangesInDiagram = new ArrayList<PhysicalLink>();
        for (DEdge anEdge : CapellaServices.getService().getDiagramContainer((EObject)context).getEdges()) {
            if (!(anEdge.getTarget() instanceof PhysicalLink)) continue;
            existingExchangesInDiagram.add((PhysicalLink)anEdge.getTarget());
        }
        Component currentComponent = null;
        EObject target = context.getTarget();
        if (target instanceof Component) {
            currentComponent = (Component)CsServices.getService().getComponentType((Component)target);
        } else if (target instanceof Part) {
            currentComponent = (Component)CsServices.getService().getComponentType((Part)target);
        }
        for (PhysicalPort aPort : ComponentExt.getOwnedPhysicalPort(currentComponent)) {
            allPhysicalLinks.addAll(aPort.getInvolvedLinks());
        }
        for (PhysicalLink aPhysicalLink : allPhysicalLinks) {
            if (existingExchangesInDiagram.contains(aPhysicalLink)) continue;
            returnedList.add(aPhysicalLink);
        }
        return returnedList;
    }

    public List<PhysicalLink> getAvailablePhysicalLinksToInsertOld(DNodeContainer context) {
        ArrayList<PhysicalLink> returnedList = new ArrayList<PhysicalLink>();
        ArrayList allPhysicalLinks = new ArrayList();
        ArrayList<PhysicalLink> existingExchangesInDiagram = new ArrayList<PhysicalLink>();
        for (DEdge anEdge : CapellaServices.getService().getDiagramContainer((EObject)context).getEdges()) {
            if (!(anEdge.getTarget() instanceof PhysicalLink)) continue;
            existingExchangesInDiagram.add((PhysicalLink)anEdge.getTarget());
        }
        Component currentComponent = null;
        EObject target = context.getTarget();
        if (target instanceof Component) {
            currentComponent = (Component)CsServices.getService().getComponentType((Component)target);
        } else if (target instanceof Part) {
            currentComponent = (Component)CsServices.getService().getComponentType((Part)target);
        }
        for (PhysicalPort aPort : ComponentExt.getOwnedPhysicalPort(currentComponent)) {
            allPhysicalLinks.addAll(aPort.getInvolvedLinks());
        }
        for (PhysicalLink aPhysicalLink : allPhysicalLinks) {
            if (existingExchangesInDiagram.contains(aPhysicalLink)) continue;
            returnedList.add(aPhysicalLink);
        }
        return returnedList;
    }

    public List<PhysicalPath> getAllPhysicalPaths(EObject context) {
        return PhysicalPathExt.getAllPhysicalPaths((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)context));
    }

    public EObject createABPhysicalLink(EObject context, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        PhysicalLinkEnd end;
        EObject sourceTarget = sourceView.getTarget();
        EObject targetTarget = targetView.getTarget();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)sourceView);
        InformationsExchanger sourceRelatedPart = CsServices.getService().getRelatedPart(sourceView);
        InformationsExchanger targetRelatedPart = CsServices.getService().getRelatedPart(targetView);
        Part sourcePart = null;
        Part targetPart = null;
        if (sourceRelatedPart instanceof Part) {
            sourcePart = (Part)sourceRelatedPart;
        }
        if (targetRelatedPart instanceof Part) {
            targetPart = (Part)targetRelatedPart;
        }
        EdgeTarget nodeSource = null;
        EdgeTarget nodeTarget = null;
        PhysicalPort sourcePort = null;
        if (sourceTarget instanceof PhysicalPort) {
            sourcePort = (PhysicalPort)sourceTarget;
            nodeSource = (EdgeTarget)sourceView;
        } else if (sourcePart != null) {
            sourcePort = CsFactory.eINSTANCE.createPhysicalPort();
            ((Component)sourcePart.getType()).getOwnedFeatures().add((Object)sourcePort);
            CapellaServices.getService().creationService((EObject)sourcePort);
            nodeSource = (EdgeTarget)CsServices.getService().createViewOrGetPhysicalPort((DNodeContainer)sourceView, (Port)sourcePort).getKey();
        }
        PhysicalPort targetPort = null;
        if (targetTarget instanceof PhysicalPort) {
            targetPort = (PhysicalPort)targetTarget;
            nodeTarget = (EdgeTarget)targetView;
        } else if (targetPart != null) {
            targetPort = CsFactory.eINSTANCE.createPhysicalPort();
            ((Component)targetPart.getType()).getOwnedFeatures().add((Object)targetPort);
            CapellaServices.getService().creationService((EObject)targetPort);
            nodeTarget = (EdgeTarget)CsServices.getService().createViewOrGetPhysicalPort((DNodeContainer)targetView, (Port)targetPort).getKey();
        }
        PhysicalLink exchange = CsFactory.eINSTANCE.createPhysicalLink();
        if (CsServices.getService().isMultipartMode((ModelElement)sourceTarget)) {
            end = CsFactory.eINSTANCE.createPhysicalLinkEnd();
            end.setPart(sourcePart);
            end.setPort(sourcePort);
            exchange.getLinkEnds().add((Object)end);
            exchange.getOwnedPhysicalLinkEnds().add((Object)end);
            CapellaServices.getService().creationService((EObject)end);
        } else {
            exchange.getLinkEnds().add((Object)sourcePort);
        }
        if (CsServices.getService().isMultipartMode((ModelElement)sourceTarget)) {
            end = CsFactory.eINSTANCE.createPhysicalLinkEnd();
            end.setPart(targetPart);
            end.setPort(targetPort);
            exchange.getLinkEnds().add((Object)end);
            exchange.getOwnedPhysicalLinkEnds().add((Object)end);
            CapellaServices.getService().creationService((EObject)end);
        } else {
            exchange.getLinkEnds().add((Object)targetPort);
        }
        PhysicalLinkExt.attachToDefaultContainer((PhysicalLink)exchange);
        CapellaServices.getService().creationService((EObject)exchange);
        DiagramServices.getDiagramServices().createEdge(FaServices.getFaServices().getMappingABPhysicalLink(diagram), nodeSource, nodeTarget, (EObject)exchange);
        CsServices.getService().setInterpreterVariable(context, "result", (EObject)exchange);
        return context;
    }

    public EObject createPhysicalPath(EObject context, List<EObject> views, EObject source) {
        if (!views.isEmpty() && source != null) {
            ArrayList<PhysicalLink> newList = new ArrayList<PhysicalLink>();
            for (EObject aSelectedElement : views) {
                if (!(aSelectedElement instanceof DEdge) || ((DEdge)aSelectedElement).getTarget() == null || !(((DEdge)aSelectedElement).getTarget() instanceof PhysicalLink)) continue;
                newList.add((PhysicalLink)((DEdge)aSelectedElement).getTarget());
            }
            Part sourcePath = this.canBeInvolvedInPhysicalPath(source) ? (Part)((PartitionableElement)source).getRepresentingPartitions().get(0) : (Part)source;
            EObject target = ((DSemanticDiagram)CapellaServices.getService().getDiagramContainer(views.get(0))).getTarget();
            Component container = (Component)target;
            return PhysicalPathExt.createPhysicalPath((Component)container, newList, (Part)sourcePath);
        }
        return null;
    }

    public boolean canBeInvolvedInPhysicalPath(EObject source) {
        return this.canHavePhysicalPort(source);
    }

    public boolean canHavePhysicalPort(EObject source) {
        return source instanceof AbstractPhysicalComponent || source instanceof AbstractActor || source instanceof System || source instanceof Component && this.isLogicalSystemComponent(source);
    }

    private boolean isLogicalSystemComponent(EObject source) {
        return source.eContainer() instanceof LogicalArchitecture;
    }

    public List<EObject> getAvailableSourcesOfPhysicalPath(EObject context, List<EObject> views) {
        HashMap<Part, Integer> parts = new HashMap<Part, Integer>();
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject eObject : views) {
            if (!(eObject instanceof DEdge) || ((DEdge)eObject).getTarget() == null || !(((DEdge)eObject).getTarget() instanceof PhysicalLink)) continue;
            PhysicalLink currentLink = (PhysicalLink)((DEdge)eObject).getTarget();
            Part sourcePart = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourcePart((PhysicalLink)currentLink);
            Part targetPart = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPart((PhysicalLink)currentLink);
            int i = 1;
            if (parts.containsKey(sourcePart)) {
                i = (Integer)parts.get(sourcePart) + 1;
            }
            parts.put(sourcePart, i);
            i = 1;
            if (parts.containsKey(targetPart)) {
                i = (Integer)parts.get(targetPart) + 1;
            }
            parts.put(targetPart, i);
        }
        for (Map.Entry entry : parts.entrySet()) {
            if ((Integer)entry.getValue() != 1) continue;
            if (CsServices.getService().isMultipartMode((ModelElement)entry.getKey())) {
                result.add((EObject)entry.getKey());
                continue;
            }
            result.add((EObject)((Part)entry.getKey()).getType());
        }
        return result;
    }

    public boolean isValidPhysicalPort(EObject context, EObject container) {
        if (container instanceof Part) {
            return this.canHavePhysicalPort((EObject)((Part)container).getAbstractType());
        }
        return false;
    }

    public boolean canBeInvolvedInPhysicalLink(EObject context) {
        if (context instanceof Part) {
            return this.canHavePhysicalPort((EObject)((Part)context).getAbstractType());
        }
        return context instanceof PhysicalPort;
    }

    public boolean isValidPhysicalPathSelection(EObject context, List<EObject> views) {
        SimpleOrientedGraph graph = new SimpleOrientedGraph();
        if (!views.isEmpty()) {
            for (EObject aSelectedElement : views) {
                if (!(aSelectedElement instanceof DEdge) || ((DEdge)aSelectedElement).getTarget() == null || !(((DEdge)aSelectedElement).getTarget() instanceof PhysicalLink)) continue;
                PhysicalLink aSelectedExchange = (PhysicalLink)((DEdge)aSelectedElement).getTarget();
                Part sourcePart = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourcePart((PhysicalLink)aSelectedExchange);
                Part targetPart = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPart((PhysicalLink)aSelectedExchange);
                graph.addNode((Object)sourcePart, (Object)targetPart);
            }
            if (!graph.isEmpty()) {
                for (Part aPart : graph.getGraph().keySet()) {
                    if (graph.getNotOrientedNeighbours((Object)aPart).size() <= 2) continue;
                    return false;
                }
                return graph.isValid() && !this.getAvailableSourcesOfPhysicalPath(context, views).isEmpty();
            }
            return false;
        }
        return false;
    }

    public EObject showHidePhysicalPaths(EObject context, List<PhysicalPath> selectedPaths, DDiagram diagram) {
        HashMap<PhysicalPath, DNode> displayedPaths = new HashMap<PhysicalPath, DNode>();
        for (DNode aNode : diagram.getNodes()) {
            if (!(aNode.getTarget() instanceof PhysicalPath)) continue;
            displayedPaths.put((PhysicalPath)aNode.getTarget(), aNode);
        }
        NodeMapping physicalPathMapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, MappingConstantsHelper.getMappingPhysicalPath(diagram));
        for (PhysicalPath physicalPath : selectedPaths) {
            if (displayedPaths.containsKey(physicalPath)) continue;
            DiagramServices.getDiagramServices().createNode(physicalPathMapping, (EObject)physicalPath, (DragAndDropTarget)diagram, diagram);
        }
        for (Map.Entry entry : displayedPaths.entrySet()) {
            if (selectedPaths.contains(entry.getKey())) continue;
            DiagramServices.getDiagramServices().removeNodeView((DNode)entry.getValue());
        }
        return context;
    }

    public List<PhysicalPath> getAvailablePhysicalPathsToInsert(EObject element, DSemanticDiagram diagram) {
        HashSet<EObject> viewTargets = new HashSet<EObject>();
        for (DEdge anEdge : diagram.getEdges()) {
            if (!(anEdge.getTarget() instanceof PhysicalLink)) continue;
            viewTargets.add(anEdge.getTarget());
        }
        ArrayList<PhysicalPath> result = new ArrayList<PhysicalPath>();
        block1: for (PhysicalPath aPath : this.getAllPhysicalPaths(diagram.getTarget())) {
            Collection involvedLinks = PhysicalPathExt.getFlatPhysicalLinks((PhysicalPath)aPath);
            if (result.contains(aPath)) continue;
            for (EObject link : involvedLinks) {
                if (!viewTargets.contains(link)) continue;
                result.add(aPath);
                continue block1;
            }
        }
        return result;
    }

    public PhysicalPort getRelatedPort(AbstractPhysicalLinkEnd end) {
        return org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getRelatedPort((AbstractPhysicalLinkEnd)end);
    }

    public List<PhysicalPath> getDisplayedPhysicalPaths(DDiagram diagram) {
        ArrayList<PhysicalPath> returnedList = new ArrayList<PhysicalPath>();
        for (DNode aNode : diagram.getNodes()) {
            if (!(aNode.getTarget() instanceof PhysicalPath)) continue;
            returnedList.add((PhysicalPath)aNode.getTarget());
        }
        return returnedList;
    }

    public EObject reconnectPhysicalLink(PhysicalLink link, AbstractPhysicalLinkEnd source, AbstractPhysicalLinkEnd target) {
        int index = link.getLinkEnds().indexOf((Object)source);
        link.getLinkEnds().add(index, (Object)target);
        link.getLinkEnds().remove((Object)source);
        return link;
    }

    public EObject manageComponentDeployments(DNodeContainer view, List<DeployableElement> selectedElements, boolean isBehaviour) {
        Part currentPart = (Part)view.getTarget();
        DDiagram currentDiagram = CapellaServices.getService().getDiagramContainer((EObject)view);
        HashMap<Part, DNodeContainer> displayedDeployments = new HashMap<Part, DNodeContainer>();
        ContainerMapping deploymentMapping = this.getDeploymentMapping(currentDiagram);
        for (DDiagramElement aDiagramElement : view.getOwnedDiagramElements()) {
            if (!aDiagramElement.getMapping().equals(deploymentMapping)) continue;
            displayedDeployments.put((Part)aDiagramElement.getTarget(), (DNodeContainer)aDiagramElement);
        }
        ArrayList<AbstractDeploymentLink> linksToRemove = new ArrayList<AbstractDeploymentLink>(1);
        for (AbstractDeploymentLink aLink : currentPart.getOwnedDeploymentLinks()) {
            if (selectedElements.contains(aLink.getDeployedElement()) || !(aLink.getDeployedElement() instanceof Part)) continue;
            Part aDeployedPart = (Part)aLink.getDeployedElement();
            if ((!isBehaviour || !this.isBehaviour(aDeployedPart)) && (isBehaviour || !this.isNode(aDeployedPart))) continue;
            if (displayedDeployments.containsKey(aDeployedPart)) {
                DiagramServices.getDiagramServices().removeContainerView((EObject)displayedDeployments.get(aDeployedPart));
            }
            linksToRemove.add(aLink);
        }
        CapellaServices.getService().removeElements(linksToRemove);
        List<Part> deployedComponents = this.getDeployedComponents(currentPart, isBehaviour);
        for (DeployableElement aSelectedElement : selectedElements) {
            if (deployedComponents.contains(aSelectedElement)) continue;
            PartDeploymentLink newLink = DeploymentFactory.eINSTANCE.createPartDeploymentLink();
            currentPart.getOwnedDeploymentLinks().add((Object)newLink);
            newLink.setLocation((DeploymentTarget)currentPart);
            newLink.setDeployedElement(aSelectedElement);
            DiagramServices.getDiagramServices().createContainer(deploymentMapping, (EObject)aSelectedElement, (DragAndDropTarget)view, currentDiagram);
        }
        return view;
    }

    public ContainerMapping getDeploymentMapping(DDiagram diagram) {
        return DiagramServices.getDiagramServices().getContainerMapping(diagram, MappingConstantsHelper.getMappingABDeployedElement(diagram));
    }

    public boolean isBehaviour(Part part) {
        AbstractType componentType = CsServices.getService().getComponentType(part);
        PhysicalComponent comp = null;
        if (componentType instanceof PhysicalComponent) {
            comp = (PhysicalComponent)componentType;
            return PhysicalComponentNature.BEHAVIOR.equals((Object)comp.getNature());
        }
        return false;
    }

    public boolean isNode(Part part) {
        AbstractType componentType = CsServices.getService().getComponentType(part);
        PhysicalComponent comp = null;
        if (componentType instanceof PhysicalComponent) {
            comp = (PhysicalComponent)componentType;
            return PhysicalComponentNature.NODE.equals((Object)comp.getNature());
        }
        return false;
    }

    public boolean isPhysicalActor(Part part) {
        AbstractType componentType = CsServices.getService().getComponentType(part);
        return componentType instanceof PhysicalActor;
    }

    public void updateInternalPhysicalPaths(DDiagram diagram) {
        Set<DEdge> physicalPathEdges;
        PhysicalPath physicalPath;
        HashMap<PhysicalPath, DNode> displayedPaths = this.computePhysicalPathToNodeMap(diagram);
        HashMap<PhysicalLink, DEdge> displayedPhysicalLinks = this.computePhysicalLinkToEdgeMap(diagram);
        HashMap<PhysicalPath, Set<DEdge>> physicalPathToVisibleInternalEdges = this.computePhysicalPathToEdgesMap(diagram);
        for (Map.Entry<PhysicalPath, Set<DEdge>> entry : physicalPathToVisibleInternalEdges.entrySet()) {
            physicalPath = entry.getKey();
            if (displayedPaths.containsKey(physicalPath)) continue;
            physicalPathEdges = entry.getValue();
            for (DEdge edge : physicalPathEdges) {
                diagram.getOwnedDiagramElements().remove((Object)edge);
            }
        }
        for (Map.Entry<PhysicalPath, Set<DEdge>> entry : displayedPaths.entrySet()) {
            physicalPath = entry.getKey();
            physicalPathEdges = this.updatePhysicalPathInternalLinks(physicalPath, displayedPhysicalLinks);
        }
        for (Map.Entry<PhysicalPath, Set<DEdge>> entry : physicalPathToVisibleInternalEdges.entrySet()) {
            Set<DEdge> edges = entry.getValue();
            for (DEdge edge : edges) {
                if (this.isValidInternalLinkEdge(edge.getSourceNode(), edge.getTargetNode())) continue;
                DiagramServices.getDiagramServices().removeEdgeView(edge);
            }
        }
    }

    public void updatePhysicalPathStyles(DDiagram diagram) {
        HashMap<PhysicalPath, Set<DEdge>> physicalPathToEdgesMap = this.computePhysicalPathToEdgesMap(diagram);
        HashMap<PhysicalPath, DNode> displayedPaths = this.computePhysicalPathToNodeMap(diagram);
        HashMap<PhysicalLink, DEdge> displayedPhysicalLinks = this.computePhysicalLinkToEdgeMap(diagram);
        HashMap<DEdge, Set<PhysicalPath>> coloredLinks = this.computeEdgeToPhysicalPathsMap(displayedPaths, displayedPhysicalLinks);
        for (Map.Entry<PhysicalPath, DNode> entry : displayedPaths.entrySet()) {
            DNode node = entry.getValue();
            PhysicalPath physicalPath = entry.getKey();
            this.updatePhysicalPathNodeColor(node, displayedPaths.values());
            RGBValues physicalPathColor = ShapeUtil.getNodeColorStyle(node);
            HashSet internalLinks = physicalPathToEdgesMap.get(physicalPath);
            internalLinks = internalLinks == null ? new HashSet() : internalLinks;
            internalLinks.remove(null);
            for (DEdge internalLink : internalLinks) {
                this.customizeInternalLinksEdgeStyle(internalLink, physicalPathColor);
            }
            for (PhysicalLink link : PhysicalPathExt.getFlatPhysicalLinks((PhysicalPath)physicalPath)) {
                if (!displayedPhysicalLinks.containsKey(link)) continue;
                DEdge currentEdge = displayedPhysicalLinks.get(link);
                RGBValues color = coloredLinks.get(currentEdge).size() == 1 ? physicalPathColor : ShapeUtil.getBlackColor();
                this.customizePhysicalLinkEdgeStyle(currentEdge, color);
            }
        }
        for (DEdge aPL : displayedPhysicalLinks.values()) {
            if (coloredLinks.containsKey(aPL)) continue;
            this.resetPhysicalLinkStyle(aPL);
        }
    }

    private HashMap<DEdge, Set<PhysicalPath>> computeEdgeToPhysicalPathsMap(HashMap<PhysicalPath, DNode> displayedPaths, HashMap<PhysicalLink, DEdge> displayedPhysicalLinks) {
        HashMap<DEdge, Set<PhysicalPath>> coloredLinks = new HashMap<DEdge, Set<PhysicalPath>>();
        for (Map.Entry<PhysicalPath, DNode> me : displayedPaths.entrySet()) {
            for (PhysicalLink link : PhysicalPathExt.getFlatPhysicalLinks((PhysicalPath)me.getKey())) {
                if (!displayedPhysicalLinks.containsKey(link)) continue;
                DEdge linkEdge = displayedPhysicalLinks.get(link);
                if (!coloredLinks.containsKey(linkEdge)) {
                    HashSet<PhysicalPath> newSet = new HashSet<PhysicalPath>();
                    newSet.add(me.getKey());
                    coloredLinks.put(linkEdge, newSet);
                    continue;
                }
                coloredLinks.get(linkEdge).add(me.getKey());
            }
        }
        return coloredLinks;
    }

    private HashMap<PhysicalPath, Set<DEdge>> computePhysicalPathToEdgesMap(DDiagram diagram) {
        HashMap<PhysicalPath, Set<DEdge>> displayedIL = new HashMap<PhysicalPath, Set<DEdge>>();
        for (DEdge anEdge : diagram.getEdges()) {
            if (!(anEdge.getTarget() instanceof PhysicalPath)) continue;
            if (!displayedIL.containsKey(anEdge.getTarget())) {
                HashSet<DEdge> newSet = new HashSet<DEdge>();
                newSet.add(anEdge);
                displayedIL.put((PhysicalPath)anEdge.getTarget(), newSet);
                continue;
            }
            displayedIL.get(anEdge.getTarget()).add(anEdge);
        }
        return displayedIL;
    }

    private HashMap<PhysicalLink, DEdge> computePhysicalLinkToEdgeMap(DDiagram diagram) {
        HashMap<PhysicalLink, DEdge> displayedPhysicalLinks = new HashMap<PhysicalLink, DEdge>();
        for (DEdge anEdge : diagram.getEdges()) {
            if (!(anEdge.getTarget() instanceof PhysicalLink)) continue;
            displayedPhysicalLinks.put((PhysicalLink)anEdge.getTarget(), anEdge);
        }
        return displayedPhysicalLinks;
    }

    private HashMap<PhysicalPath, DNode> computePhysicalPathToNodeMap(DDiagram diagram) {
        HashMap<PhysicalPath, DNode> displayedPaths = new HashMap<PhysicalPath, DNode>();
        for (DDiagramElement aNode : diagram.getOwnedDiagramElements()) {
            if (!(aNode instanceof DNode) || !(aNode.getTarget() instanceof PhysicalPath)) continue;
            displayedPaths.put((PhysicalPath)aNode.getTarget(), (DNode)aNode);
        }
        return displayedPaths;
    }

    private boolean isValidNodeForInternalLink(EdgeTarget currentNode) {
        if (currentNode == null) {
            return false;
        }
        if (!(currentNode instanceof DNode)) {
            return false;
        }
        return DiagramServices.getDiagramServices().isABorderedNode((AbstractDNode)((DNode)currentNode));
    }

    protected Collection<PhysicalLink> getFlatPreviousPhysicalLinks(PhysicalPathInvolvement physicalPathInvolvement) {
        HashSet<PhysicalLink> result = new HashSet<PhysicalLink>();
        for (PhysicalPathInvolvement involvment : PhysicalPathExt.getFlatPreviousLinkInvolvements((PhysicalPathInvolvement)physicalPathInvolvement)) {
            if (!(involvment.getInvolved() instanceof PhysicalLink)) continue;
            result.add((PhysicalLink)involvment.getInvolved());
        }
        return result;
    }

    protected Collection<PhysicalLink> getFlatNextPhysicalLinks(PhysicalPathInvolvement physicalPathInvolvement) {
        HashSet<PhysicalLink> result = new HashSet<PhysicalLink>();
        for (PhysicalPathInvolvement involvment : PhysicalPathExt.getFlatNextExchangeInvolvements((PhysicalPathInvolvement)physicalPathInvolvement)) {
            if (!(involvment.getInvolved() instanceof PhysicalLink)) continue;
            result.add((PhysicalLink)involvment.getInvolved());
        }
        return result;
    }

    protected Set<DEdge> updatePhysicalPathInternalLinks(PhysicalPath path, HashMap<PhysicalLink, DEdge> displayedPhysicalLinks) {
        HashSet<DEdge> internalLinks = new HashSet<DEdge>();
        Collection flatPartInvolvements = PhysicalPathExt.getFlatInvolvementsOf((PhysicalPath)path, (EClass)CsPackage.Literals.PART);
        for (PhysicalPathInvolvement partInvolvement : flatPartInvolvements) {
            Part currentPart = (Part)partInvolvement.getInvolvedElement();
            EList previousLinkInvolvements = partInvolvement.getPreviousInvolvements();
            EList nextLinkInvolvements = partInvolvement.getNextInvolvements();
            if (previousLinkInvolvements.isEmpty() && !nextLinkInvolvements.isEmpty()) {
                internalLinks.addAll(this.updateInternalLinks(path, displayedPhysicalLinks, currentPart, (EList<PhysicalPathInvolvement>)nextLinkInvolvements));
                continue;
            }
            if (!previousLinkInvolvements.isEmpty() && nextLinkInvolvements.isEmpty()) {
                internalLinks.addAll(this.updateInternalLinks(path, displayedPhysicalLinks, currentPart, (EList<PhysicalPathInvolvement>)previousLinkInvolvements));
                continue;
            }
            for (PhysicalPathInvolvement previousInvolvement : previousLinkInvolvements) {
                for (PhysicalPathInvolvement nextInvolvement : nextLinkInvolvements) {
                    PhysicalLink previousLink = (PhysicalLink)previousInvolvement.getInvolvedElement();
                    PhysicalLink nextLink = (PhysicalLink)nextInvolvement.getInvolvedElement();
                    if (!displayedPhysicalLinks.containsKey(previousLink) || !displayedPhysicalLinks.containsKey(nextLink)) continue;
                    DEdge previousEdge = displayedPhysicalLinks.get(previousLink);
                    DEdge nextEdge = displayedPhysicalLinks.get(nextLink);
                    if (previousEdge == null || nextEdge == null) continue;
                    EdgeTarget firstNode = this.getPortOnInvolved(previousEdge, (InvolvedElement)currentPart);
                    EdgeTarget secondNode = this.getPortOnInvolved(nextEdge, (InvolvedElement)currentPart);
                    if (!this.isValidNodeForInternalLink(firstNode) || !this.isValidNodeForInternalLink(secondNode) || !this.isValidInternalLinkEdge(firstNode, secondNode)) continue;
                    internalLinks.add(this.retrieveInternalLink((DNode)firstNode, (DNode)secondNode, path));
                }
            }
        }
        if (internalLinks.contains(null)) {
            internalLinks.remove(null);
        }
        return internalLinks;
    }

    private Set<DEdge> updateInternalLinks(PhysicalPath path, HashMap<PhysicalLink, DEdge> displayedPhysicalLinks, Part currentPart, EList<PhysicalPathInvolvement> linkInvolvements) {
        HashSet<DEdge> internalLinks = new HashSet<DEdge>();
        int size = linkInvolvements.size();
        PhysicalPathInvolvement[] linkInvolvementsArray = (PhysicalPathInvolvement[])linkInvolvements.toArray((Object[])new PhysicalPathInvolvement[size]);
        int index = 0;
        while (index < size - 1) {
            EdgeTarget firstNode;
            DEdge currentEdge;
            PhysicalPathInvolvement physicalPathInvolvement = linkInvolvementsArray[index];
            PhysicalLink currentLink = (PhysicalLink)physicalPathInvolvement.getInvolvedElement();
            if (displayedPhysicalLinks.containsKey(currentLink) && (currentEdge = displayedPhysicalLinks.get(currentLink)) != null && this.isValidNodeForInternalLink(firstNode = this.getPortOnInvolved(currentEdge, (InvolvedElement)currentPart))) {
                EdgeTarget secondNode;
                DEdge nextEdge;
                PhysicalLink nextLink;
                PhysicalPathInvolvement nextPhysicalPathInvolvement = linkInvolvementsArray[index + 1];
                PhysicalLink physicalLink = nextLink = index + 1 == size ? null : (PhysicalLink)nextPhysicalPathInvolvement.getInvolvedElement();
                if (nextLink != null && displayedPhysicalLinks.containsKey(nextLink) && (nextEdge = displayedPhysicalLinks.get(nextLink)) != null && this.isValidNodeForInternalLink(secondNode = this.getPortOnInvolved(nextEdge, (InvolvedElement)currentPart)) && this.isValidInternalLinkEdge(firstNode, secondNode)) {
                    internalLinks.add(this.retrieveInternalLink((DNode)firstNode, (DNode)secondNode, path));
                }
            }
            ++index;
        }
        return internalLinks;
    }

    private EdgeTarget getPortOnInvolved(DEdge edge, InvolvedElement involved) {
        EdgeTarget sourceNode = edge.getSourceNode();
        if (sourceNode.eContainer() instanceof DNodeContainer && ((DNodeContainer)sourceNode.eContainer()).getTarget().equals(involved)) {
            return sourceNode;
        }
        EdgeTarget targetNode = edge.getTargetNode();
        if (targetNode.eContainer() instanceof DNodeContainer && ((DNodeContainer)targetNode.eContainer()).getTarget().equals(involved)) {
            return targetNode;
        }
        return null;
    }

    public boolean isValidInternalLinkEdge(EdgeTarget currentSourceNode, EdgeTarget currentTargetNode) {
        if (currentSourceNode == null) {
            return false;
        }
        if (currentTargetNode == null) {
            return false;
        }
        List<DEdge> edgesRelatedToSource = this.getRelatedEdges(currentSourceNode);
        if (!this.hasAtLeastOneVisibleEdgeNotPhysicalPath(edgesRelatedToSource)) {
            return false;
        }
        List<DEdge> edgesRelatedToTarget = this.getRelatedEdges(currentTargetNode);
        if (!this.hasAtLeastOneVisibleEdgeNotPhysicalPath(edgesRelatedToTarget)) {
            return false;
        }
        EObject sourceParent = currentSourceNode.eContainer();
        EObject targetParent = currentTargetNode.eContainer();
        if (sourceParent != null && targetParent != null) {
            return sourceParent.equals(targetParent);
        }
        return true;
    }

    private boolean hasAtLeastOneVisibleEdgeNotPhysicalPath(List<DEdge> edgesRelatedToSource) {
        boolean sourceHasAtLeastOneVisibleEdgeNotPhysicalPath = false;
        for (DEdge dEdge : edgesRelatedToSource) {
            if (dEdge.getTarget() instanceof PhysicalPath || DiagramServices.getDiagramServices().isHidden((DDiagramElement)dEdge)) continue;
            sourceHasAtLeastOneVisibleEdgeNotPhysicalPath = true;
            break;
        }
        return sourceHasAtLeastOneVisibleEdgeNotPhysicalPath;
    }

    private List<DEdge> getRelatedEdges(EdgeTarget currentSourceNode) {
        ArrayList<DEdge> edgesRelatedToSource = new ArrayList<DEdge>();
        for (DEdge dEdge : currentSourceNode.getIncomingEdges()) {
            edgesRelatedToSource.add(dEdge);
        }
        for (DEdge dEdge : currentSourceNode.getOutgoingEdges()) {
            edgesRelatedToSource.add(dEdge);
        }
        return edgesRelatedToSource;
    }

    protected DEdge retrieveInternalLink(DNode sourceNode, DNode targetNode, PhysicalPath physicalPath) {
        if (sourceNode == targetNode) {
            return null;
        }
        DEdge internalLink = null;
        for (DEdge anEdge : DiagramServices.getDiagramServices().getOutgoingEdges((EdgeTarget)sourceNode)) {
            if (!(anEdge.getTarget() instanceof PhysicalPath) || !anEdge.getTarget().equals(physicalPath) || anEdge.getSourceNode() == null || anEdge.getTargetNode() == null || (!anEdge.getSourceNode().equals(sourceNode) || !anEdge.getTargetNode().equals(targetNode)) && (!anEdge.getSourceNode().equals(targetNode) || !anEdge.getTargetNode().equals(sourceNode))) continue;
            internalLink = anEdge;
            break;
        }
        for (DEdge anEdge : DiagramServices.getDiagramServices().getIncomingEdges((EdgeTarget)sourceNode)) {
            if (!(anEdge.getTarget() instanceof PhysicalPath) || !anEdge.getTarget().equals(physicalPath) || anEdge.getSourceNode() == null || anEdge.getTargetNode() == null || (!anEdge.getSourceNode().equals(sourceNode) || !anEdge.getTargetNode().equals(targetNode)) && (!anEdge.getSourceNode().equals(targetNode) || !anEdge.getTargetNode().equals(sourceNode))) continue;
            internalLink = anEdge;
            break;
        }
        if (internalLink == null) {
            internalLink = this.createInternalLink(sourceNode, targetNode, physicalPath);
        }
        return internalLink;
    }

    public DEdge createInternalLink(DNode sourceNode, DNode targetNode, PhysicalPath physicalPath) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)sourceNode);
        EdgeMapping mapping = this.getPhysicalPathInternLinkEdgeMapping(diagram);
        DEdge newEdge = DiagramServices.getDiagramServices().findDEdgeElement(diagram, (EdgeTarget)sourceNode, (EdgeTarget)targetNode, (EObject)physicalPath, mapping);
        if (newEdge == null) {
            newEdge = DiagramServices.getDiagramServices().createEdge(mapping, (EdgeTarget)sourceNode, (EdgeTarget)targetNode, (EObject)physicalPath);
        }
        return newEdge;
    }

    public void customizeInternalLinksEdgeStyle(DEdge edge, RGBValues color) {
        RGB rgbColor = new RGB(color.getRed(), color.getGreen(), color.getBlue());
        ShapeUtil.setEdgeColorStyle(edge, rgbColor);
        ShapeUtil.setEdgeThickStyle(edge, THICK_EDGE_PHYSICAL_PATH);
    }

    public void customizePhysicalLinkEdgeStyle(DEdge edge, RGBValues color) {
        String defaultSize;
        EdgeStyleDescription desc;
        EdgeStyle edgeStyle = edge.getOwnedStyle();
        Integer currentSize = edgeStyle.getSize();
        DiagramElementMapping mapping = DiagramServices.getDiagramServices().getEdgeMapping(edge);
        if (mapping != null && (desc = (EdgeStyleDescription)this.getMappingHelper((DSemanticDecorator)edge).getBestStyleDescription(mapping, edge.getTarget(), (EObject)edge, edge.eContainer(), CapellaServices.getService().getDiagramContainer((EObject)edge))) != null && (defaultSize = desc.getSizeComputationExpression()) != null && currentSize != null && (currentSize.equals(Integer.valueOf(defaultSize)) || currentSize.equals(THICK_EDGE_PHYSICAL_PATH))) {
            RGB rgbColor = new RGB(color.getRed(), color.getGreen(), color.getBlue());
            ShapeUtil.setEdgeColorStyle(edge, rgbColor);
            ShapeUtil.setEdgeThickStyle(edge, THICK_EDGE_PHYSICAL_PATH);
        }
    }

    public boolean isCompletePhysicalPath(PhysicalPath path, DDiagram diagram) {
        Collection physicalLinksOnThePath = PhysicalPathExt.getFlatPhysicalLinks((PhysicalPath)path);
        int numberOfVisibleRelatedPLEdges = 0;
        for (DEdge anEdge : diagram.getEdges()) {
            EObject edgeTarget;
            if (!anEdge.isVisible() || !((edgeTarget = anEdge.getTarget()) instanceof PhysicalLink) || !physicalLinksOnThePath.contains(edgeTarget)) continue;
            ++numberOfVisibleRelatedPLEdges;
        }
        return numberOfVisibleRelatedPLEdges == physicalLinksOnThePath.size();
    }

    public String getPhysicalPathLabel(PhysicalPath path, DDiagram diagram) {
        boolean displayInvalidLabel;
        String label = EObjectExt.getText((EObject)path);
        boolean isComplete = this.isCompletePhysicalPath(path, diagram);
        boolean displayIncompleteLabel = !isComplete && ScopedCapellaPreferencesStore.getBoolean((String)"org.polarsys.capella.core.sirius.analysis.preferences.diagrams.physicalpath.label.incomplete", (IProject)PreferencesHelper.getProject((EObject)path));
        boolean isValid = PhysicalPathExt.isPhysicalPathValid((PhysicalPath)path);
        boolean bl = displayInvalidLabel = !isValid && ScopedCapellaPreferencesStore.getBoolean((String)"org.polarsys.capella.core.sirius.analysis.preferences.diagrams.physicalpath.label.invalid", (IProject)PreferencesHelper.getProject((EObject)path));
        if (displayIncompleteLabel || displayInvalidLabel) {
            label = String.valueOf(label) + " (";
        }
        if (displayIncompleteLabel) {
            label = String.valueOf(label) + INCOMPLETE_PHYSICAL_PATH_LABEL;
        }
        if (displayIncompleteLabel && displayInvalidLabel) {
            label = String.valueOf(label) + ", ";
        }
        if (displayInvalidLabel) {
            label = String.valueOf(label) + INVALID_PHYSICAL_PATH_LABEL;
        }
        if (displayIncompleteLabel || displayInvalidLabel) {
            label = String.valueOf(label) + ")";
        }
        return label;
    }

    public void updatePhysicalPathNodeColor(DNode pathNode, Collection<DNode> visiblePhysicalPaths) {
        RGBValues color = ShapeUtil.getNodeColorStyle(pathNode);
        LinkedList<RGB> colorList = new LinkedList<RGB>();
        RGB blue = new RGB(24, 114, 248);
        RGB yellow = new RGB(249, 252, 103);
        RGB purple = new RGB(160, 32, 240);
        RGB gray = new RGB(136, 136, 136);
        RGB orange = new RGB(255, 165, 0);
        RGB green = new RGB(34, 139, 34);
        RGB brown = new RGB(165, 42, 42);
        colorList.addLast(blue);
        colorList.addLast(brown);
        colorList.addLast(orange);
        colorList.addLast(green);
        colorList.addLast(purple);
        colorList.addLast(yellow);
        colorList.addLast(gray);
        boolean changeColor = false;
        if (ShapeUtil.isSameColor(color, gray)) {
            changeColor = true;
        }
        for (DNode aPhysicalPath : visiblePhysicalPaths) {
            if (aPhysicalPath.equals(pathNode)) continue;
            RGBValues nodeColor = ShapeUtil.getNodeColorStyle(aPhysicalPath);
            if (ShapeUtil.isSameColor(nodeColor, color)) {
                changeColor = true;
            }
            ShapeUtil.removeColorFromList(nodeColor, colorList);
        }
        if (!changeColor) {
            return;
        }
        if (!colorList.isEmpty()) {
            ShapeUtil.setColorStyle(pathNode, (RGB)colorList.get(0));
        }
    }

    public void resetPhysicalLinkStyle(DEdge aEdge) {
        DiagramElementMapping mapping = DiagramServices.getDiagramServices().getEdgeMapping(aEdge);
        if (mapping != null) {
            EdgeStyleDescription desc = (EdgeStyleDescription)this.getMappingHelper((DSemanticDecorator)aEdge).getBestStyleDescription(mapping, aEdge.getTarget(), (EObject)aEdge, aEdge.eContainer(), CapellaServices.getService().getDiagramContainer((EObject)aEdge));
            String defaultStyleSize = desc.getSizeComputationExpression();
            EdgeStyle edgeStyle = aEdge.getOwnedStyle();
            Integer currentSize = edgeStyle.getSize();
            if (currentSize != null && defaultStyleSize != null && (currentSize.equals(THICK_EDGE_PHYSICAL_PATH) || currentSize.equals(defaultStyleSize)) && ShapeUtil.resetEdgeThickStyle(aEdge, Integer.valueOf(defaultStyleSize))) {
                ShapeUtil.resetEdgeColorStyle(aEdge, ShapeUtil.getDefaultColor((DSemanticDecorator)aEdge, (EObject)desc, desc.getStrokeColor()));
            }
        }
    }

    public EdgeMapping getPhysicalPathInternLinkEdgeMapping(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingPhysicalPathInternLink(diagram);
        return DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
    }

    public List<PhysicalPathInvolvement> getPreviousPhysicalPathInvolvements(PhysicalPathInvolvement involvement) {
        return involvement.getPreviousInvolvements();
    }

    public List<CapellaElement> getAllComponentsFromPhysicalArchitecture(PhysicalArchitecture arch) {
        ArrayList<CapellaElement> returnedList = new ArrayList<CapellaElement>();
        BlockArchitectureExt.getAllComponentsFromPA((BlockArchitecture)arch, returnedList);
        return returnedList;
    }

    public boolean isAnEdgeInvolvementAvailableInPPD(EObject context, PhysicalPathInvolvement source, PhysicalPathInvolvement target) {
        boolean result;
        Collection<PhysicalLink> commonExchanges = this.getPPDCommonPhysicalLinks(source, target);
        boolean bl = result = !commonExchanges.isEmpty();
        return result && !this.findInvolvementInNext(target, source, new HashSet<PhysicalPathInvolvement>());
    }

    public boolean findInvolvementInNext(PhysicalPathInvolvement currentInvolvement, PhysicalPathInvolvement involvementToFind, Set<PhysicalPathInvolvement> visitedInvolvements) {
        if (visitedInvolvements.contains(currentInvolvement)) {
            return false;
        }
        if (currentInvolvement.equals(involvementToFind)) {
            return true;
        }
        HashSet<PhysicalPathInvolvement> involvements = new HashSet<PhysicalPathInvolvement>(visitedInvolvements);
        involvements.add(currentInvolvement);
        for (PhysicalPathInvolvement aNext : currentInvolvement.getNextInvolvements()) {
            if (!this.findInvolvementInNext(aNext, involvementToFind, involvements)) continue;
            return true;
        }
        return false;
    }

    public List<PhysicalLink> getAvailablePhysicaLinks(PhysicalPath path, Part source, Part target) {
        ArrayList<PhysicalLink> returnedPhysicalLinks = new ArrayList<PhysicalLink>();
        Collection incoming = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getAllRelatedPhysicalLinks((Part)target);
        Collection outgoing = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getAllRelatedPhysicalLinks((Part)source);
        List involvedElements = PhysicalPathExt.getInvolvedElements((PhysicalPath)path);
        for (PhysicalLink aPhysicalLink : incoming) {
            if (!outgoing.contains(aPhysicalLink) || involvedElements.contains(aPhysicalLink)) continue;
            returnedPhysicalLinks.add(aPhysicalLink);
        }
        return returnedPhysicalLinks;
    }

    public List<PhysicalLink> getPPDInvolvePhysicalLinkAndComponentScope(DNode node) {
        ArrayList<PhysicalLink> returnedList = new ArrayList<PhysicalLink>();
        List<PhysicalLink> existingInvolvedFE = this.getOutgoingIncomingEdgePhysicalLinks(node);
        PhysicalPathInvolvement selectedInvolvement = (PhysicalPathInvolvement)node.getTarget();
        if (selectedInvolvement.getInvolved() instanceof PhysicalPath) {
            existingInvolvedFE.addAll(PhysicalPathExt.getFlatPhysicalLinks((PhysicalPath)((PhysicalPath)selectedInvolvement.getInvolved())));
        }
        for (PhysicalLink aFE : PhysicalPathExt.getFlatOutgoingIncomingLinks((PhysicalPathInvolvement)selectedInvolvement)) {
            if (existingInvolvedFE.contains(aFE)) continue;
            returnedList.add(aFE);
        }
        return returnedList;
    }

    public List<PhysicalLink> getPPDInvolvePhysicalLinkAndPartScope(DNode node) {
        ArrayList<PhysicalLink> returnedList = new ArrayList<PhysicalLink>();
        List<PhysicalLink> existingInvolvedFE = this.getOutgoingIncomingEdgePhysicalLinks(node);
        PhysicalPathInvolvement selectedInvolvement = (PhysicalPathInvolvement)node.getTarget();
        if (selectedInvolvement.getInvolved() instanceof PhysicalPath) {
            existingInvolvedFE.addAll(PhysicalPathExt.getFlatPhysicalLinks((PhysicalPath)((PhysicalPath)selectedInvolvement.getInvolved())));
        }
        for (PhysicalLink aFE : PhysicalPathExt.getFlatOutgoingIncomingLinks((PhysicalPathInvolvement)selectedInvolvement)) {
            if (existingInvolvedFE.contains(aFE)) continue;
            returnedList.add(aFE);
        }
        return returnedList;
    }

    public List<PhysicalLink> getAvailablePhysicalLinkToInsertInPPD(DNode node) {
        ArrayList<PhysicalLink> returnedList = new ArrayList<PhysicalLink>();
        ArrayList<PhysicalLink> existingInvolvedLinks = new ArrayList<PhysicalLink>();
        for (DEdge anEdge : DiagramServices.getDiagramServices().getOutgoingEdges((EdgeTarget)node)) {
            PhysicalPathInvolvement currentInv;
            if (!(anEdge.getTarget() instanceof PhysicalPathInvolvement) || !((currentInv = (PhysicalPathInvolvement)anEdge.getTarget()).getInvolvedElement() instanceof PhysicalLink)) continue;
            existingInvolvedLinks.add((PhysicalLink)currentInv.getInvolvedElement());
        }
        PhysicalPathInvolvement selectedInvolvement = (PhysicalPathInvolvement)node.getTarget();
        List involvedElements = PhysicalPathExt.getInvolvedElements((PhysicalPath)((PhysicalPath)selectedInvolvement.eContainer()));
        for (PhysicalLink aLink : org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getAllRelatedPhysicalLinks((Part)((Part)selectedInvolvement.getInvolvedElement()))) {
            if (existingInvolvedLinks.contains(aLink) || involvedElements.contains(aLink)) continue;
            returnedList.add(aLink);
        }
        return returnedList;
    }

    public Part getOppositePart(PhysicalLink link, EObject involvedElement) {
        Part sourcePart = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourcePart((PhysicalLink)link);
        if (involvedElement.equals(sourcePart)) {
            return org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPart((PhysicalLink)link);
        }
        if (involvedElement instanceof PhysicalPath) {
            for (PhysicalPathInvolvement involvment : PhysicalPathExt.getFlatLastPhysicalPathInvolvments((PhysicalPath)((PhysicalPath)involvedElement))) {
                if (!sourcePart.equals(involvment.getInvolvedElement())) continue;
                return org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPart((PhysicalLink)link);
            }
        }
        return sourcePart;
    }

    @Deprecated
    public boolean isPhysicalPathEnd(PhysicalPathInvolvement inv) {
        return false;
    }

    private MappingHelper getMappingHelper(DSemanticDecorator semanticDecorator) {
        return new MappingHelper(SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semanticDecorator.getTarget()));
    }

    public Collection<PhysicalLink> getPPDInvolvePhysicalLinkScope(EObject context, EObject source, EObject target) {
        PhysicalPathInvolvement sourceInvolvment = (PhysicalPathInvolvement)source;
        PhysicalPathInvolvement targetInvolvment = (PhysicalPathInvolvement)target;
        if (sourceInvolvment.getInvolved() != null && sourceInvolvment.getInvolved().equals(targetInvolvment.getInvolved())) {
            return Collections.emptyList();
        }
        Collection<PhysicalLink> commonExchanges = this.getPPDCommonPhysicalLinks(sourceInvolvment, targetInvolvment);
        if (sourceInvolvment.getInvolved() instanceof PhysicalPath) {
            commonExchanges.removeAll(PhysicalPathExt.getFlatPhysicalLinks((PhysicalPath)((PhysicalPathReference)sourceInvolvment).getReferencedPhysicalPath()));
        }
        if (targetInvolvment.getInvolved() instanceof PhysicalPath) {
            commonExchanges.removeAll(PhysicalPathExt.getFlatPhysicalLinks((PhysicalPath)((PhysicalPathReference)targetInvolvment).getReferencedPhysicalPath()));
        }
        return commonExchanges;
    }

    private Collection<PhysicalLink> getPPDCommonPhysicalLinks(PhysicalPathInvolvement source, PhysicalPathInvolvement target) {
        return PhysicalPathExt.getFlatCommonPhysicalLinks((PhysicalPathInvolvement)source, (PhysicalPathInvolvement)target);
    }

    public HashMapSet<PhysicalLink, PhysicalPath> getPPDInvolvePhysicalLinkAndPhysicalPathScope(DNode node) {
        HashMapSet<PhysicalLink, PhysicalPath> set = new HashMapSet<PhysicalLink, PhysicalPath>();
        if (node == null || node.getTarget() == null || node.getTarget().eIsProxy()) {
            return set;
        }
        EObject target = node.getTarget();
        if (!(target instanceof PhysicalPathInvolvement)) {
            return set;
        }
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)node);
        if (!(diagram instanceof DSemanticDecorator)) {
            return set;
        }
        List<PhysicalLink> existingInvolvedFE = this.getOutgoingIncomingEdgePhysicalLinks(node);
        PhysicalPathInvolvement involvement = (PhysicalPathInvolvement)target;
        Collection outgoing = PhysicalPathExt.getFlatOutgoingIncomingLinks((PhysicalPathInvolvement)involvement);
        HashSet<Part> sourceParts = new HashSet<Part>();
        if (involvement.getInvolved() instanceof PhysicalPath) {
            PhysicalPath path = (PhysicalPath)involvement.getInvolved();
            outgoing.removeAll(PhysicalPathExt.getFlatPhysicalLinks((PhysicalPath)path));
            sourceParts.addAll(PhysicalPathExt.getFlatPhysicalPathFirstParts((PhysicalPath)path));
            sourceParts.addAll(PhysicalPathExt.getFlatPhysicalPathLastParts((PhysicalPath)path));
        } else if (involvement.getInvolved() instanceof Part) {
            sourceParts.add((Part)involvement.getInvolved());
        }
        Collection<PhysicalPath> paths = this.getPPDInvolvePhysicalPathScope((DSemanticDecorator)diagram);
        for (PhysicalPath path : paths) {
            if (path.equals(involvement.getInvolved())) continue;
            Collection incoming = PhysicalPathExt.getFlatOutgoingIncomingLinks((PhysicalPath)path);
            incoming.retainAll(outgoing);
            incoming.removeAll(PhysicalPathExt.getFlatPhysicalLinks((PhysicalPath)path));
            LinkedHashSet targetParts = new LinkedHashSet();
            targetParts.addAll(PhysicalPathExt.getFlatPhysicalPathFirstParts((PhysicalPath)path));
            targetParts.addAll(PhysicalPathExt.getFlatPhysicalPathLastParts((PhysicalPath)path));
            for (PhysicalLink exchange : incoming) {
                if (existingInvolvedFE.contains(exchange)) continue;
                HashSet parts = new HashSet();
                parts.addAll(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourceParts((PhysicalLink)exchange));
                parts.addAll(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetParts((PhysicalLink)exchange));
                parts.removeAll(sourceParts);
                parts.retainAll(targetParts);
                if (parts.isEmpty()) continue;
                set.put(exchange, path);
            }
        }
        return set;
    }

    private List<PhysicalLink> getOutgoingIncomingEdgePhysicalLinks(DNode node) {
        PhysicalPathInvolvement currentInv;
        ArrayList<PhysicalLink> existingInvolvedFE = new ArrayList<PhysicalLink>();
        for (DEdge anEdge : DiagramServices.getDiagramServices().getOutgoingEdges((EdgeTarget)node)) {
            if (!(anEdge.getTarget() instanceof PhysicalPathInvolvement) || !((currentInv = (PhysicalPathInvolvement)anEdge.getTarget()).getInvolvedElement() instanceof PhysicalLink)) continue;
            existingInvolvedFE.add((PhysicalLink)currentInv.getInvolvedElement());
        }
        for (DEdge anEdge : DiagramServices.getDiagramServices().getIncomingEdges((EdgeTarget)node)) {
            if (!(anEdge.getTarget() instanceof PhysicalPathInvolvement) || !((currentInv = (PhysicalPathInvolvement)anEdge.getTarget()).getInvolvedElement() instanceof PhysicalLink)) continue;
            existingInvolvedFE.add((PhysicalLink)currentInv.getInvolvedElement());
        }
        return existingInvolvedFE;
    }

    public HashMapSet<PhysicalLink, PhysicalPath> getInvolvePhysicalLinkAndPhysicalPathInitialSelection(AbstractDNode context) {
        return new HashMapSet<PhysicalLink, PhysicalPath>();
    }

    public void involvedPPDPhysicalLinkPhysicalPath(AbstractDNode context, HashMapSet<PhysicalLink, PhysicalPath> scope, HashMapSet<PhysicalLink, PhysicalPath> initialSelection, HashMapSet<PhysicalLink, PhysicalPath> selection) {
        if (context == null) {
            return;
        }
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)context);
        if (!(diagram instanceof DSemanticDecorator)) {
            return;
        }
        PhysicalPath sourceFC = (PhysicalPath)((DSemanticDecorator)diagram).getTarget();
        EObject target = context.getTarget();
        if (target == null || target.eIsProxy() || !(target instanceof PhysicalPathInvolvement)) {
            return;
        }
        PhysicalPathInvolvement iSource = (PhysicalPathInvolvement)context.getTarget();
        for (PhysicalLink link : selection.keySet()) {
            Iterator iterator = selection.get(link).iterator();
            while (iterator.hasNext()) {
                PhysicalPath chain = (PhysicalPath)iterator.next();
                PhysicalPathInvolvement iExchange = CsFactory.eINSTANCE.createPhysicalPathInvolvement();
                iExchange.setInvolved((InvolvedElement)link);
                sourceFC.getOwnedPhysicalPathInvolvements().add((Object)iExchange);
                iSource.getNextInvolvements().add((Object)iExchange);
                PhysicalPathReference iChain = CsFactory.eINSTANCE.createPhysicalPathReference();
                iChain.setInvolved((InvolvedElement)chain);
                sourceFC.getOwnedPhysicalPathInvolvements().add((Object)iChain);
                iExchange.getNextInvolvements().add((Object)iChain);
                AbstractNodeMapping nodeMapping = DiagramServices.getDiagramServices().getAbstractNodeMapping(diagram, "PPD_PhysicalPath");
                if (nodeMapping == null) {
                    return;
                }
                AbstractDNode node = DiagramServices.getDiagramServices().createAbstractDNode(nodeMapping, (EObject)iChain, (DragAndDropTarget)diagram, diagram);
                if (node == null) {
                    return;
                }
                EdgeMapping edgeMapping = DiagramServices.getDiagramServices().getEdgeMapping(diagram, "PPD_PhysicalLink");
                if (edgeMapping == null) {
                    return;
                }
                DiagramServices.getDiagramServices().createEdge(edgeMapping, (EdgeTarget)context, (EdgeTarget)node, (EObject)iExchange);
            }
        }
    }

    public PhysicalComponent createPhysicalComponent(EObject container) {
        PhysicalComponent component = PaFactory.eINSTANCE.createPhysicalComponent();
        if (component != null) {
            if (container instanceof PhysicalComponent) {
                PhysicalComponent componentContainer = (PhysicalComponent)container;
                componentContainer.getOwnedPhysicalComponents().add((Object)component);
            }
            CapellaServices.getService().creationService((EObject)component);
        }
        return component;
    }
}

