/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.processor;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.ActorPkg;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.helpers.ctx.services.ActorPkgExt;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.communication.CommunicationFactory;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkKind;
import org.polarsys.capella.core.data.la.LogicalActor;
import org.polarsys.capella.core.data.la.LogicalActorPkg;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;

public class CommunicationLinkDelegationSCtoLC {
    protected List<Map.Entry<Component, Component>> pairs = new ArrayList<Map.Entry<Component, Component>>();

    public CommunicationLinkDelegationSCtoLC(LogicalComponent logicalComponent) {
        this.computeComponentPairsForComponentFromLogicalLevel((Component)logicalComponent);
    }

    public CommunicationLinkDelegationSCtoLC(LogicalActor logicalActor) {
        this.computeComponentPairsForComponentFromLogicalLevel((Component)logicalActor);
    }

    public CommunicationLinkDelegationSCtoLC(LogicalActorPkg logicalActorPck) {
        for (Component logicalActor : ActorPkgExt.getAllActors((LogicalActorPkg)logicalActorPck)) {
            this.computeComponentPairsForComponentFromLogicalLevel(logicalActor);
        }
    }

    public CommunicationLinkDelegationSCtoLC(System systemComponent) {
        this.computeComponentPairsForComponentFromSystemLevel((Component)systemComponent);
    }

    public CommunicationLinkDelegationSCtoLC(Actor actor) {
        this.computeComponentPairsForComponentFromSystemLevel((Component)actor);
    }

    public CommunicationLinkDelegationSCtoLC(ActorPkg actorPck) {
        for (Component actor : ActorPkgExt.getAllActors((ActorPkg)actorPck)) {
            this.computeComponentPairsForComponentFromSystemLevel(actor);
        }
    }

    private void computeComponentPairsForComponentFromLogicalLevel(Component logicalComponent) {
        for (Component sourceComponent : logicalComponent.getAllocatedComponents()) {
            this.pairs.add(new AbstractMap.SimpleEntry<Component, Component>(sourceComponent, logicalComponent));
        }
    }

    private void computeComponentPairsForComponentFromSystemLevel(Component systemComponent) {
        for (Component targetComponent : systemComponent.getAllocatingComponents()) {
            this.pairs.add(new AbstractMap.SimpleEntry<Component, Component>(systemComponent, targetComponent));
        }
    }

    public void perform() {
        for (Map.Entry<Component, Component> pair : this.pairs) {
            this.perform(pair.getKey(), pair.getValue());
        }
    }

    protected void perform(Component source, Component target) {
        Hashtable<ExchangeItem, ArrayList<CommunicationLink>> item2targetLinks = new Hashtable<ExchangeItem, ArrayList<CommunicationLink>>();
        for (CommunicationLink targetLink : target.getOwnedCommunicationLinks()) {
            ExchangeItem item = targetLink.getExchangeItem();
            ArrayList<CommunicationLink> links = (ArrayList<CommunicationLink>)item2targetLinks.get(item);
            if (links == null) {
                links = new ArrayList<CommunicationLink>();
                item2targetLinks.put(item, links);
            }
            links.add(targetLink);
        }
        for (CommunicationLink sourceLink : source.getOwnedCommunicationLinks()) {
            CommunicationLinkKind kind = sourceLink.getKind();
            ExchangeItem item = sourceLink.getExchangeItem();
            List candidatelinks = (List)item2targetLinks.get(item);
            CommunicationLink equivalentLink = null;
            if (candidatelinks != null) {
                for (CommunicationLink targetLink : candidatelinks) {
                    if (targetLink.getKind() != kind) continue;
                    equivalentLink = targetLink;
                    break;
                }
            }
            if (equivalentLink == null) {
                CommunicationLink link = CommunicationFactory.eINSTANCE.createCommunicationLink();
                target.getOwnedCommunicationLinks().add((Object)link);
                link.setKind(sourceLink.getKind());
                link.setExchangeItem(item);
                CapellaElementExt.creationService((EObject)link);
                continue;
            }
            candidatelinks.remove(equivalentLink);
            if (!candidatelinks.isEmpty()) continue;
            item2targetLinks.remove(item);
        }
        Enumeration items = item2targetLinks.keys();
        while (items.hasMoreElements()) {
            ExchangeItem item = (ExchangeItem)items.nextElement();
            for (CommunicationLink link : (List)item2targetLinks.get(item)) {
                EcoreUtil.delete((EObject)link);
            }
        }
    }
}

