/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.helpers;

import java.util.Collection;
import java.util.MissingResourceException;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ItemProviderDecorator;

public class EObjectLabelProviderHelper {
    private static final String FEATURE_GENERATED_KEY_SUFFIX = "_feature";
    private static final String METACLASS_GENERATED_KEY_SUFFIX = "_type";
    private static final String GENERATED_KEY_PREFIX = "_UI_";
    private static final String METACLASS_DISPLAY_PREFIX = "[";
    private static final String METACLASS_DISPLAY_SUFFIX = "] ";

    protected static IItemLabelProvider getItemLabelProvider(EObject object) {
        if (object == null) {
            return null;
        }
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
        if (editingDomain == null) {
            return null;
        }
        return (IItemLabelProvider)editingDomain.getAdapterFactory().adapt((Notifier)object, IItemLabelProvider.class);
    }

    public static String getText(EObject object) {
        IItemLabelProvider provider = EObjectLabelProviderHelper.getItemLabelProvider(object);
        String label = "";
        if (provider != null) {
            label = provider.getText((Object)object);
        }
        return label;
    }

    public static String getMetaclassLabel(EObject object, boolean addBrackets) {
        String label = null;
        if (object == null) {
            return label;
        }
        ItemProviderAdapter provider = EObjectLabelProviderHelper.getItemProvider(object);
        if (provider instanceof ItemProviderAdapter) {
            label = EObjectLabelProviderHelper.getMetaclassLabel(object.eClass(), provider);
        }
        if (addBrackets) {
            label = METACLASS_DISPLAY_PREFIX + label + METACLASS_DISPLAY_SUFFIX;
        }
        return label;
    }

    public static ItemProviderAdapter getItemProvider(EObject object) {
        if (object == null) {
            return null;
        }
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
        if (editingDomain == null) {
            return null;
        }
        return EObjectLabelProviderHelper.getItemProvider(object, editingDomain.getAdapterFactory());
    }

    public static ItemProviderAdapter getItemProvider(EObject object, AdapterFactory factory) {
        IChangeNotifier notifier;
        if (object == null) {
            return null;
        }
        Adapter adapter = factory.adapt((Notifier)object, IItemLabelProvider.class);
        if (adapter instanceof ItemProviderDecorator && (notifier = ((ItemProviderDecorator)adapter).getDecoratedItemProvider()) instanceof ItemProviderAdapter) {
            return (ItemProviderAdapter)notifier;
        }
        return (ItemProviderAdapter)adapter;
    }

    public static String getMetaclassLabel(EClass cls, ItemProviderAdapter provider) {
        String label = null;
        if (cls == null || provider == null) {
            return label;
        }
        try {
            label = provider.getString(GENERATED_KEY_PREFIX + cls.getName() + METACLASS_GENERATED_KEY_SUFFIX);
        }
        catch (MissingResourceException e) {
            label = "<<MissingResourceException>> [" + cls.getName() + "]";
        }
        return label;
    }

    public static String getFeatureLabel(EStructuralFeature feature, ItemProviderAdapter provider) {
        String label = null;
        if (feature == null || provider == null) {
            return label;
        }
        String featureKey = String.valueOf(feature.getEContainingClass().getName()) + '_' + feature.getName();
        label = provider.getString(GENERATED_KEY_PREFIX + featureKey + FEATURE_GENERATED_KEY_SUFFIX);
        return label;
    }

    protected static void getText(Object affectedObject, StringBuilder value) {
        if (affectedObject != null) {
            if (affectedObject instanceof EObject) {
                value.append(EObjectLabelProviderHelper.getText((EObject)affectedObject));
            } else if (affectedObject instanceof Collection) {
                Collection coll = (Collection)affectedObject;
                value.append("{");
                for (Object o : coll) {
                    EObjectLabelProviderHelper.getText(o, value);
                    value.append(';');
                }
                if (coll.size() > 0) {
                    value.deleteCharAt(value.length() - 1);
                }
                value.append("}");
            } else {
                value.append(affectedObject.toString());
            }
        }
    }

    public static String getText(Object object) {
        StringBuilder buffer = new StringBuilder();
        EObjectLabelProviderHelper.getText(object, buffer);
        return buffer.toString();
    }
}

