/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.helpers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.polarsys.capella.common.MdeCommonActivator;

public class FileHelper2 {
    public static boolean containsFileExtension(String filePath) {
        return FileHelper2.getFileExtension(filePath) != null;
    }

    public static String getFileExtension(String filePath) {
        String result = null;
        File file = new File(filePath);
        String fileShortName = file.getName();
        int index = fileShortName.lastIndexOf(46);
        if (index != -1) {
            result = fileShortName.substring(index);
        }
        return result;
    }

    public static File writeContentInTemporaryFile(String fileName, String fileExtension, byte[] content) throws IOException {
        String prefix = fileName;
        if (prefix.length() < 3) {
            prefix = prefix + '_' + '_' + '_';
        }
        File tempFile = File.createTempFile(prefix, fileExtension);
        tempFile.deleteOnExit();
        FileHelper2.writeFile(tempFile, content);
        return tempFile;
    }

    public static void writeFile(File file, byte[] content) {
        block22: {
            if (file == null || content == null) {
                MdeCommonActivator.getDefault().log(4, "Error while writing file", new IllegalArgumentException());
                return;
            }
            AbstractInterruptibleChannel channel = null;
            try {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                        channel = fileOutputStream.getChannel();
                        ((FileChannel)channel).write(ByteBuffer.wrap(content));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception exception) {
                    MdeCommonActivator.getDefault().log(4, "Error while writing file", exception);
                    if (channel == null || !channel.isOpen()) break block22;
                    try {
                        channel.close();
                    }
                    catch (IOException exception2) {
                        MdeCommonActivator.getDefault().log(4, "Error while closing file channel", exception2);
                    }
                }
            }
            finally {
                if (channel != null && channel.isOpen()) {
                    try {
                        channel.close();
                    }
                    catch (IOException exception) {
                        MdeCommonActivator.getDefault().log(4, "Error while closing file channel", exception);
                    }
                }
            }
        }
    }
}

