/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.utils.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.polarsys.capella.common.utils.graph.IDirectedGraph;

public class SCCSearch<T> {
    private IDirectedGraph<T> graph;
    private int index;
    private Map<T, Properties> propertyMap;
    private Stack<T> stack;
    private List<List<T>> result;

    public List<List<T>> findSCC(IDirectedGraph<T> graph, boolean strict) {
        this.result = new ArrayList<List<T>>();
        this.graph = graph;
        this.index = 0;
        this.propertyMap = new HashMap<T, Properties>();
        this.stack = new Stack();
        this.result = new ArrayList<List<T>>();
        Iterator<T> nodes = graph.getNodes();
        while (nodes.hasNext()) {
            T current = nodes.next();
            if (this.propertyMap.get(current) != null) continue;
            this.strongconnect(current, strict);
        }
        return this.result;
    }

    private void strongconnect(T current, boolean strict) {
        Properties properties = new Properties(this.index, this.index);
        this.propertyMap.put(current, properties);
        ++this.index;
        this.stack.push(current);
        Iterator<T> successors = this.graph.getSucessors(current);
        while (successors.hasNext()) {
            T successor = successors.next();
            if (this.propertyMap.get(successor) == null) {
                this.strongconnect(successor, strict);
                properties.lowlink = Math.min(properties.lowlink, this.propertyMap.get(successor).lowlink);
                continue;
            }
            if (!this.stack.contains(successor)) continue;
            properties.lowlink = Math.min(properties.lowlink, this.propertyMap.get(successor).lowlink);
        }
        if (properties.lowlink == properties.index) {
            T t;
            ArrayList<T> scc = new ArrayList<T>();
            do {
                t = this.stack.pop();
                scc.add(t);
            } while (t != current);
            if (scc.size() == 1) {
                if (strict) {
                    this.result.add(scc);
                }
            } else {
                this.result.add(scc);
            }
        }
    }

    private final class Properties {
        int index;
        int lowlink;

        public Properties(int index, int lowlink) {
            this.index = index;
            this.lowlink = lowlink;
        }
    }
}

