/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.obfuscator.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.core.model.obfuscator.ObfuscatorHelper;

public class ObfuscateRepresentationCommand
extends AbstractReadWriteCommand {
    private DRepresentation _representation;

    public ObfuscateRepresentationCommand(DRepresentation representation_p) {
        this._representation = representation_p;
    }

    public void run() {
        if (this._representation != null) {
            this.obfuscateDRepresentation(this._representation);
            this._representation = null;
        }
    }

    protected void obfuscateDRepresentation(DRepresentation representation_p) {
        representation_p.setName(ObfuscatorHelper.generateUnreadableString(this._representation.getName()));
        representation_p.setDocumentation(ObfuscatorHelper.generateUnreadableString(this._representation.getDocumentation()));
        this.obfuscateGMFDiagram(representation_p);
        this.obfuscateRepresentationElements(representation_p);
    }

    protected void obfuscateGMFDiagram(DRepresentation representation_p) {
        for (EObject diag : this.getOpposites((EObject)representation_p, NotationPackage.eINSTANCE.getView_Element())) {
            if (diag == null || !(diag instanceof Diagram)) continue;
            Diagram diagram = (Diagram)diag;
            for (Object child : diagram.getPersistedChildren()) {
                if (child == null) continue;
                if (child instanceof Shape) {
                    this.obfuscateShape((Shape)child);
                    continue;
                }
                if (!(child instanceof Node)) continue;
                this.obfuscateNode((Node)child);
            }
        }
    }

    protected void obfuscateNode(Node parent_p) {
        Style style;
        if (parent_p == null) {
            return;
        }
        for (Object child : parent_p.getPersistedChildren()) {
            if (child == null) continue;
            if (child instanceof Shape) {
                this.obfuscateShape((Shape)child);
                continue;
            }
            if (!(child instanceof Node)) continue;
            this.obfuscateNode((Node)child);
        }
        if (parent_p.getElement() == null && (style = parent_p.getStyle(NotationPackage.Literals.SHAPE_STYLE)) instanceof ShapeStyle) {
            ShapeStyle ss = (ShapeStyle)style;
            ss.setDescription(ObfuscatorHelper.generateUnreadableString(ss.getDescription()));
        }
    }

    protected void obfuscateShape(Shape shape_p) {
        if (shape_p == null) {
            return;
        }
        shape_p.setDescription(ObfuscatorHelper.generateUnreadableString(shape_p.getDescription()));
    }

    protected void obfuscateRepresentationElements(DRepresentation representation_p) {
        TreeIterator content = representation_p.eAllContents();
        while (content.hasNext()) {
            EObject object = (EObject)content.next();
            if (object == null || object.eIsProxy() || !(object instanceof DRepresentationElement)) continue;
            this.obfuscateDRepresentationElement((DRepresentationElement)object);
        }
    }

    protected void obfuscateDRepresentationElement(DRepresentationElement dElement) {
        EObject target = dElement.getTarget();
        String value = dElement.getName();
        if (value != null && value.length() > 0) {
            if (target != null && !target.eIsProxy()) {
                if (target instanceof AbstractNamedElement) {
                    String semanticName = ((AbstractNamedElement)target).getName();
                    if (semanticName != null && semanticName.length() > 0) {
                        dElement.setName(semanticName);
                    } else {
                        dElement.setName(ObfuscatorHelper.generateUnreadableString(value));
                    }
                } else {
                    dElement.setName(ObfuscatorHelper.generateUnreadableString(value));
                }
            } else {
                dElement.setName(ObfuscatorHelper.generateUnreadableString(value));
            }
        }
        if (dElement instanceof DDiagramElement) {
            this.obfuscateDDiagramElement((DDiagramElement)dElement);
        }
        if (dElement instanceof DLine) {
            this.obfuscateDLine((DLine)dElement);
        }
        if (dElement instanceof DColumn) {
            this.obfuscateDColumn((DColumn)dElement);
        }
        if (dElement instanceof DCell) {
            this.obfuscateDCell((DCell)dElement);
        }
    }

    protected void obfuscateDDiagramElement(DDiagramElement object_p) {
        DDiagramElement dElement = object_p;
        EObject target = dElement.getTarget();
        String name = dElement.getTooltipText();
        if (name != null && name.length() > 0) {
            if (target != null && !target.eIsProxy()) {
                if (target instanceof AbstractNamedElement) {
                    String semanticName = ((AbstractNamedElement)target).getName();
                    if (semanticName != null && semanticName.length() > 0) {
                        dElement.setTooltipText(semanticName);
                    } else {
                        dElement.setTooltipText(ObfuscatorHelper.generateUnreadableString(name));
                    }
                } else {
                    dElement.setTooltipText(ObfuscatorHelper.generateUnreadableString(name));
                }
            } else {
                dElement.setTooltipText(ObfuscatorHelper.generateUnreadableString(name));
            }
        }
        if (dElement instanceof DEdge) {
            this.obfuscateDEdge((DEdge)dElement);
        }
    }

    protected void obfuscateDEdge(DEdge object) {
        String value = object.getBeginLabel();
        if (value != null && value.length() > 0) {
            object.setBeginLabel(ObfuscatorHelper.generateUnreadableString(value));
        }
        if ((value = object.getEndLabel()) != null && value.length() > 0) {
            object.setEndLabel(ObfuscatorHelper.generateUnreadableString(value));
        }
    }

    protected void obfuscateDLine(DLine dElement) {
        EObject target = dElement.getTarget();
        String value = dElement.getLabel();
        if (value != null && value.length() > 0) {
            if (target != null && !target.eIsProxy()) {
                if (target instanceof AbstractNamedElement) {
                    String semanticName = ((AbstractNamedElement)target).getName();
                    if (semanticName != null && semanticName.length() > 0) {
                        dElement.setLabel(semanticName);
                    } else {
                        dElement.setLabel(ObfuscatorHelper.generateUnreadableString(value));
                    }
                } else {
                    dElement.setLabel(ObfuscatorHelper.generateUnreadableString(value));
                }
            } else {
                dElement.setLabel(ObfuscatorHelper.generateUnreadableString(value));
            }
        }
    }

    protected void obfuscateDColumn(DColumn dElement) {
        EObject target = dElement.getTarget();
        String value = dElement.getLabel();
        if (value != null && value.length() > 0) {
            if (target != null && !target.eIsProxy()) {
                if (target instanceof AbstractNamedElement) {
                    String semanticName = ((AbstractNamedElement)target).getName();
                    if (semanticName != null && semanticName.length() > 0) {
                        dElement.setLabel(semanticName);
                    } else {
                        dElement.setLabel(ObfuscatorHelper.generateUnreadableString(value));
                    }
                } else {
                    dElement.setLabel(ObfuscatorHelper.generateUnreadableString(value));
                }
            } else {
                dElement.setLabel(ObfuscatorHelper.generateUnreadableString(value));
            }
        }
    }

    protected void obfuscateDCell(DCell dElement) {
        EObject target = dElement.getTarget();
        String value = dElement.getLabel();
        if (value != null && value.length() > 0 && !"X".equals(value)) {
            if (target != null && !target.eIsProxy()) {
                if (target instanceof AbstractNamedElement) {
                    String semanticName = ((AbstractNamedElement)target).getName();
                    if (semanticName != null && semanticName.length() > 0) {
                        dElement.setLabel(semanticName);
                    } else {
                        dElement.setLabel(ObfuscatorHelper.generateUnreadableString(value));
                    }
                } else {
                    dElement.setLabel(ObfuscatorHelper.generateUnreadableString(value));
                }
            } else {
                dElement.setLabel(ObfuscatorHelper.generateUnreadableString(value));
            }
        }
    }

    protected List<EObject> getOpposites(EObject element_p, EReference ref_p) {
        UniqueEList result = new UniqueEList();
        ECrossReferenceAdapter referencer = this.getGlobalReferencer(element_p);
        if (referencer != null) {
            Collection settings = referencer.getNonNavigableInverseReferences(element_p);
            for (EStructuralFeature.Setting setting : settings) {
                if (!ref_p.equals(setting.getEStructuralFeature())) continue;
                result.add(setting.getEObject());
            }
        }
        return Collections.unmodifiableList(result);
    }

    protected ECrossReferenceAdapter getGlobalReferencer(EObject elementInSession_p) {
        Session session;
        ECrossReferenceAdapter result = null;
        EObject semanticElement = ((DSemanticDecorator)elementInSession_p).getTarget();
        if (semanticElement != null && (session = SessionManager.INSTANCE.getSession(semanticElement)) != null) {
            result = session.getSemanticCrossReferencer();
        }
        return result;
    }
}

