/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.diffmerge.patterns.core.Messages;
import org.eclipse.emf.diffmerge.patterns.core.RepositoryRegistry;
import org.eclipse.emf.diffmerge.patterns.core.SingletonContributionDiscoverer;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IDeleteOperationProvider;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IIdProvider;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelEnvironment;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IPatternSupport;
import org.eclipse.emf.diffmerge.patterns.core.environment.AbstractGenericTypeUtil;
import org.eclipse.emf.diffmerge.patterns.core.environment.IdProviderDispatcher;
import org.eclipse.emf.diffmerge.patterns.core.operations.DeleteOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorePatternsPlugin
extends Plugin {
    private static CorePatternsPlugin __plugin;
    private static final IDeleteOperationProvider DEFAULT_DELETE_OPERATION_PROVIDER;
    private static final String PATTERN_SUPPORT_EXTENSION_POINT = "org.eclipse.emf.diffmerge.patterns.core.patternSupport";
    private static final String PATTERN_SUPPORT_EXTENSION_POINT_PROPERTY = "class";
    private static final String MODEL_ENVIRONMENT_EXTENSION_POINT = "org.eclipse.emf.diffmerge.patterns.core.modelEnvironment";
    private static final String MODEL_ENVIRONMENT_EXTENSION_POINT_PROPERTY = "class";
    private static final String DELETE_PROVIDER_EXTENSION_POINT = "org.eclipse.emf.diffmerge.patterns.core.deleteOperationProvider";
    private static final String DELETE_PROVIDER_EXTENSION_POINT_PROPERTY = "class";
    private final RepositoryRegistry _repositoryRegistry = new RepositoryRegistry();
    private List<IPatternSupport> _cachedPatternSupports = null;
    private IDeleteOperationProvider _deleteOperationProvider;
    private IIdProvider _idProvider = null;
    private IModelEnvironment _modelEnvironment;
    private AbstractGenericTypeUtil _genericTypeUtil;
    private static final String GENERIC_TYPE_UTIL_EXTENSION_POINT = "org.eclipse.emf.diffmerge.patterns.core.genericTypeUtil";
    private static final String GENERIC_TYPE_UTIL_POINT_PROPERTY = "class";

    static {
        DEFAULT_DELETE_OPERATION_PROVIDER = new IDeleteOperationProvider(){

            public DeleteOperation getDeleteOperation(Collection<? extends EObject> toDelete_p, boolean skipConfirmation_p, boolean isExpensive_p, Object context_p) {
                return new DeleteOperation(toDelete_p, isExpensive_p, context_p);
            }

            @Override
            public boolean isInModel(EObject element_p) {
                return element_p.eResource() != null;
            }
        };
    }

    public static CorePatternsPlugin getDefault() {
        return __plugin;
    }

    private IDeleteOperationProvider discoverRegisteredDeleteOperationProvider() {
        IConfigurationElement[] config;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = config = registry.getConfigurationElementsFor(DELETE_PROVIDER_EXTENSION_POINT);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object o = e.createExecutableExtension("class");
                if (o instanceof IDeleteOperationProvider) {
                    return (IDeleteOperationProvider)o;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    private IModelEnvironment discoverRegisteredModelEnvironment() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] config = registry.getConfigurationElementsFor(MODEL_ENVIRONMENT_EXTENSION_POINT);
        ArrayList<IModelEnvironment> environments = new ArrayList<IModelEnvironment>();
        IConfigurationElement[] iConfigurationElementArray = config;
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object o = e.createExecutableExtension("class");
                if (o instanceof IModelEnvironment) {
                    environments.add((IModelEnvironment)o);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
        Collection<IModelEnvironment> reducedEnvs = this.reduceByOverride(environments);
        if (reducedEnvs != null && !reducedEnvs.isEmpty()) {
            return (IModelEnvironment)reducedEnvs.toArray()[0];
        }
        return null;
    }

    protected Collection<IModelEnvironment> reduceByOverride(List<IModelEnvironment> environments_p) {
        ArrayList<IModelEnvironment> result = new ArrayList<IModelEnvironment>(environments_p);
        for (IModelEnvironment env : environments_p) {
            for (Class<?> overridenClass : env.getOverridenClasses()) {
                ArrayList<IModelEnvironment> resultCopy = new ArrayList<IModelEnvironment>(result);
                for (IModelEnvironment cur : resultCopy) {
                    if (!cur.getClass().equals(overridenClass)) continue;
                    result.remove(cur);
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    private List<IPatternSupport> discoverRegisteredPatternSupports() {
        IConfigurationElement[] config;
        ArrayList<IPatternSupport> result = new ArrayList<IPatternSupport>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = config = registry.getConfigurationElementsFor(PATTERN_SUPPORT_EXTENSION_POINT);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object o = e.createExecutableExtension("class");
                if (o instanceof IPatternSupport && this.getModelEnvironment().isAppropriatePatternSupport((IPatternSupport)o)) {
                    result.add((IPatternSupport)o);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
        return Collections.unmodifiableList(result);
    }

    public IDeleteOperationProvider getDeleteOperationProvider() {
        if (this._deleteOperationProvider == null) {
            this._deleteOperationProvider = this.discoverRegisteredDeleteOperationProvider();
        }
        if (this._deleteOperationProvider == null) {
            this._deleteOperationProvider = DEFAULT_DELETE_OPERATION_PROVIDER;
        }
        return this._deleteOperationProvider;
    }

    public IIdProvider getIdProvider() {
        if (this._idProvider == null) {
            this._idProvider = new IdProviderDispatcher();
        }
        return this._idProvider;
    }

    public String getLabel() {
        return Messages.PatternsCorePlugin_Label;
    }

    public IModelEnvironment getModelEnvironment() {
        if (this._modelEnvironment == null) {
            this._modelEnvironment = this.discoverRegisteredModelEnvironment();
        }
        return this._modelEnvironment;
    }

    public IPatternSupport getPatternSupportFor(EObject element_p) {
        for (IPatternSupport support : this.getRegisteredPatternSupports()) {
            if (!support.isApplicableTo(element_p)) continue;
            return support;
        }
        return null;
    }

    public IPatternSupport getPatternSupportFor(IPatternApplication application_p) {
        for (IPatternSupport support : this.getRegisteredPatternSupports()) {
            if (!support.isApplicableTo(application_p)) continue;
            return support;
        }
        return null;
    }

    public String getPluginId() {
        return this.getBundle().getSymbolicName();
    }

    private List<IPatternSupport> getRegisteredPatternSupports() {
        if (this._cachedPatternSupports == null) {
            this._cachedPatternSupports = this.discoverRegisteredPatternSupports();
        }
        return this._cachedPatternSupports;
    }

    public RepositoryRegistry getRepositoryRegistry() {
        return this._repositoryRegistry;
    }

    public void setNewId(EObject element_p) {
        EcoreUtil.setID((EObject)element_p, (String)this.getIdProvider().getNewIdFor(element_p));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        __plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        __plugin = null;
        super.stop(context);
    }

    public AbstractGenericTypeUtil getGenericTypeUtil() {
        if (this._genericTypeUtil == null) {
            SingletonContributionDiscoverer d = new SingletonContributionDiscoverer(AbstractGenericTypeUtil.class, GENERIC_TYPE_UTIL_EXTENSION_POINT, "class");
            this._genericTypeUtil = (AbstractGenericTypeUtil)d.getContributedSingleton();
        }
        return this._genericTypeUtil;
    }
}

