/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.re.updateconnections.ui;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementLink;

public class CatalogElementScope {
    private final CatalogElement catalogElement;
    private final Function<CatalogElementLink, EObject> linkToElement = new Function<CatalogElementLink, EObject>(){

        public EObject apply(CatalogElementLink input) {
            return input.getTarget();
        }
    };

    public CatalogElementScope(CatalogElement catalogElement) {
        this.catalogElement = catalogElement;
    }

    public <T> ImmutableList<T> getElements(Class<T> clazz, Predicate<? super T> filter) {
        Predicate p = filter;
        if (p == null) {
            p = Predicates.alwaysTrue();
        }
        return FluentIterable.from((Iterable)this.catalogElement.getOwnedLinks()).transform(this.linkToElement).filter(clazz).filter(p).toList();
    }

    public <T> Collection<T> getElements(Class<T> clazz) {
        return this.getElements(clazz, Predicates.alwaysTrue());
    }

    public Collection<EObject> getElements() {
        return Collections2.transform((Collection)this.catalogElement.getOwnedLinks(), this.linkToElement);
    }
}

