/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.merge;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMapping;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IElementPresence;
import org.eclipse.emf.diffmerge.api.diff.IMergeableDifference;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.diffdata.EMapping;
import org.eclipse.emf.diffmerge.diffdata.impl.EComparisonImpl;
import org.eclipse.emf.diffmerge.diffdata.impl.EMappingImpl;
import org.eclipse.emf.diffmerge.impl.helpers.BidirectionalComparisonCopier;
import org.eclipse.emf.diffmerge.impl.helpers.DiffOperation;
import org.eclipse.emf.diffmerge.impl.helpers.UnidirectionalComparisonCopier;
import org.eclipse.emf.diffmerge.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.diffmerge.util.IExpensiveOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.transition.common.policies.diff.IDiffPolicy2;
import org.polarsys.capella.core.transition.common.policies.merge.IMergePolicy2;

public class ExtendedComparison
extends EComparisonImpl {
    public ExtendedComparison(IEditableModelScope targetScope, IEditableModelScope referenceScope) {
        this(targetScope, referenceScope, null);
    }

    public ExtendedComparison(IEditableModelScope targetScope, IEditableModelScope referenceScope, IEditableModelScope ancestorScope) {
        super(targetScope, referenceScope, ancestorScope);
        this.setMapping((EMapping)new EMappingImpl(){
            private BidirectionalComparisonCopier _copier = new BidirectionalComparisonCopier(){
                private UnidirectionalComparisonCopier _referenceToTargetCopier;
                private UnidirectionalComparisonCopier _targetToReferenceCopier;
                {
                    this._referenceToTargetCopier = new FixedUnidirectionalComparisonCopier(Role.REFERENCE);
                    this._targetToReferenceCopier = new FixedUnidirectionalComparisonCopier(Role.TARGET);
                }

                public EObject completeMatch(IMapping.Editable mapping, IMatch partialMatch) {
                    if (!$assertionsDisabled && !partialMatch.isPartial()) {
                        throw new AssertionError();
                    }
                    Role sourceRole = partialMatch.getUncoveredRole().opposite();
                    UnidirectionalComparisonCopier involvedCopier = sourceRole == Role.REFERENCE ? this._referenceToTargetCopier : this._targetToReferenceCopier;
                    EObject result = involvedCopier.completeMatch(partialMatch, mapping.getComparison());
                    return result;
                }

                public void completeReferences(IMapping.Editable mapping, Role role) {
                    UnidirectionalComparisonCopier involvedCopier = role == Role.TARGET ? this._referenceToTargetCopier : this._targetToReferenceCopier;
                    involvedCopier.completeReferences(mapping.getComparison());
                }
            };

            public EObject completeMatch(IMatch partialMatch) {
                return this._copier.completeMatch((IMapping.Editable)this, partialMatch);
            }

            public void completeReferences(Role role) {
                this._copier.completeReferences((IMapping.Editable)this, role);
            }
        });
    }

    protected IExpensiveOperation getDiffOperation(IDiffPolicy iDiffPolicy1, IMergePolicy mergePolicy) {
        return new DiffOperation((IComparison.Editable)this, iDiffPolicy1, mergePolicy){

            protected void setElementPresenceDependencies(IElementPresence presence) {
                super.setElementPresenceDependencies(presence);
                ((IMergePolicy2)this.getMergePolicy()).setDependencies((IMergeableDifference)presence);
            }

            protected void setReferencedValueDependencies(IReferenceValuePresence presence) {
                super.setReferencedValueDependencies(presence);
                ((IMergePolicy2)this.getMergePolicy()).setDependencies((IMergeableDifference)presence);
            }

            protected boolean detectReferenceDifferences(IMatch match, EReference reference, Role role1, Role role2, boolean create) {
                if (!$assertionsDisabled && (match == null || match.isPartial() || reference == null)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && reference.isContainer()) {
                    throw new AssertionError();
                }
                boolean result = false;
                IEditableModelScope targetScope = this.getComparison().getScope(Role.TARGET);
                IEditableModelScope referenceScope = this.getComparison().getScope(Role.REFERENCE);
                EObject targetElement = match.get(Role.TARGET);
                EObject referenceElement = match.get(Role.REFERENCE);
                List targetValues = targetScope.get(targetElement, reference);
                List referenceValues = referenceScope.get(referenceElement, reference);
                FArrayList remainingReferenceValues = new FArrayList((Collection)referenceValues, IEqualityTester.BY_REFERENCE);
                boolean checkOrder = reference.isMany() && this.getDiffPolicy().considerOrdered((EStructuralFeature)reference);
                int maxIndex = -1;
                HashMap<IMatch, EObject> isolatedTargetMatches = new HashMap<IMatch, EObject>();
                for (EObject targetValue : targetValues) {
                    boolean isIsolated;
                    IMatch targetValueMatch = this.getMapping().getMatchFor(targetValue, Role.TARGET);
                    if (targetValueMatch == null) continue;
                    EObject matchReference = targetValueMatch.get(Role.REFERENCE);
                    boolean bl = isIsolated = matchReference == null;
                    if (!isIsolated) {
                        int index = remainingReferenceValues.indexOf(matchReference);
                        boolean bl2 = isIsolated = index < 0;
                        if (checkOrder && !isIsolated) {
                            if (index < maxIndex) {
                                if (!create) {
                                    return true;
                                }
                                this.createReferenceOrderDifference(match, reference, targetValue, targetValueMatch);
                                result = true;
                                checkOrder = false;
                            } else {
                                maxIndex = index;
                            }
                        }
                    }
                    if (isIsolated) {
                        isolatedTargetMatches.put(targetValueMatch, targetValue);
                        continue;
                    }
                    remainingReferenceValues.remove(matchReference);
                }
                HashMap<IMatch, EObject> isolatedReferenceMatches = new HashMap<IMatch, EObject>();
                for (EObject remainingReferenceValue : remainingReferenceValues) {
                    IMatch referenceValueMatch = this.getMapping().getMatchFor(remainingReferenceValue, Role.REFERENCE);
                    if (referenceValueMatch == null) continue;
                    isolatedReferenceMatches.put(referenceValueMatch, remainingReferenceValue);
                }
                IDiffPolicy diffPolicy = this.getDiffPolicy();
                for (Map.Entry entry : isolatedTargetMatches.entrySet()) {
                    IMatch isolatedTargetMatch = (IMatch)entry.getKey();
                    EObject value = (EObject)entry.getValue();
                    if (diffPolicy instanceof IDiffPolicy2) {
                        if (!((IDiffPolicy2)diffPolicy).coverMatchOnReference(isolatedTargetMatch, reference)) continue;
                        this.createReferenceValueDifference(match, reference, value, isolatedTargetMatch, Role.TARGET, false);
                        result = true;
                        continue;
                    }
                    if (!diffPolicy.coverMatch(isolatedTargetMatch)) continue;
                    this.createReferenceValueDifference(match, reference, value, isolatedTargetMatch, Role.TARGET, false);
                    result = true;
                }
                for (Map.Entry entry : isolatedReferenceMatches.entrySet()) {
                    IMatch isolatedReferenceMatch = (IMatch)entry.getKey();
                    EObject value = (EObject)entry.getValue();
                    if (((IDiffPolicy2)diffPolicy).coverMatchOnReference(isolatedReferenceMatch, reference)) {
                        this.createReferenceValueDifference(match, reference, value, isolatedReferenceMatch, Role.REFERENCE, false);
                        result = true;
                        continue;
                    }
                    if (!diffPolicy.coverMatch(isolatedReferenceMatch)) continue;
                    this.createReferenceValueDifference(match, reference, value, isolatedReferenceMatch, Role.REFERENCE, false);
                    result = true;
                }
                return result;
            }
        };
    }

    protected class FixedUnidirectionalComparisonCopier
    extends UnidirectionalComparisonCopier {
        private static final long serialVersionUID = -3437137941200063000L;

        public FixedUnidirectionalComparisonCopier(Role role) {
            super(role);
        }

        public EObject copy(EObject element) {
            if (this._mergePolicy instanceof IMergePolicy2 && !((IMergePolicy2)this._mergePolicy).copy(element)) {
                return element;
            }
            return super.copy(element);
        }

        protected void copyReference(EReference reference, EObject source, EObject destination) {
            List sourceValues = this._sourceScope.get(source, reference);
            for (EObject sourceValue : sourceValues) {
                IMatch valueMatch = this._mapping.getMatchFor(sourceValue, this._sourceRole);
                if (valueMatch != null) {
                    EObject destinationValue;
                    IMatch holderMatch;
                    boolean mustCopy;
                    boolean bl = mustCopy = this.getCompletedMatches().contains(valueMatch) || reference.getEOpposite() == null && !reference.isContainment();
                    if (!mustCopy && (holderMatch = this._mapping.getMatchFor(source, this._sourceRole)) != null) {
                        boolean bl2 = mustCopy = holderMatch.getReferenceValueDifference(reference, source) == null;
                    }
                    if (mustCopy && reference.isContainment()) {
                        boolean bl3 = mustCopy = valueMatch.getOwnershipDifference(this._sourceRole.opposite()) == null;
                    }
                    if (!mustCopy || (destinationValue = valueMatch.get(this._sourceRole.opposite())) == null) continue;
                    this._destinationScope.add(destination, reference, destinationValue);
                    continue;
                }
                if (!this.useOriginalReferences || reference.getEOpposite() != null || reference.isContainment() || reference.isContainer()) continue;
                this._destinationScope.add(destination, reference, sourceValue);
            }
        }
    }
}

