/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.pa;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.deployment.TypeDeploymentLink;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;

public class GetAvailable_PhysicalComponent_DeployedComponents
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<CapellaElement> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    public List<CapellaElement> getAvailableElements(CapellaElement element) {
        PhysicalComponent currentPC = (PhysicalComponent)element;
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        List comps = SystemEngineeringExt.getAllPhysicalComponents((CapellaElement)currentPC);
        for (PhysicalComponent physicalComponent : comps) {
            if (currentPC.getNature().equals((Object)PhysicalComponentNature.BEHAVIOR) && physicalComponent.getNature().equals((Object)PhysicalComponentNature.NODE) || !this.isMultipleDeploymentAllowed() && !physicalComponent.getDeployingLinks().isEmpty() || physicalComponent.equals(currentPC) || EcoreUtil.isAncestor((EObject)physicalComponent, (EObject)currentPC)) continue;
            availableElements.add((CapellaElement)physicalComponent);
        }
        availableElements.removeAll(this.getCurrentElements(element, false));
        return availableElements;
    }

    public boolean isMultipleDeploymentAllowed() {
        return CapellaModelPreferencesPlugin.getDefault().isMultipleDeploymentAllowed();
    }

    public List<CapellaElement> getCurrentElements(CapellaElement element, boolean onlyGenerated) {
        ArrayList<CapellaElement> currentElements = new ArrayList<CapellaElement>();
        if (element instanceof PhysicalComponent) {
            PhysicalComponent pc = (PhysicalComponent)element;
            for (AbstractDeploymentLink abstractDeployment : pc.getDeploymentLinks()) {
                if (!(abstractDeployment instanceof TypeDeploymentLink)) continue;
                currentElements.add((CapellaElement)abstractDeployment.getDeployedElement());
            }
        }
        return currentElements;
    }
}

