/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalCommandStack;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.operations.LongRunningListenersRegistry;
import org.polarsys.capella.common.mdsofa.common.activator.SolFaCommonActivator;
import org.polarsys.capella.common.mdsofa.common.helper.FileHelper;
import org.polarsys.capella.common.mdsofa.common.helper.IUserEnforcedHelper;
import org.polarsys.capella.core.data.migration.AbstractMigrationRunnable;
import org.polarsys.capella.core.data.migration.Messages;
import org.polarsys.capella.core.data.migration.MigrationHelpers;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.platform.sirius.ui.session.CapellaSessionHelper;

public abstract class MigrationRunnable
extends AbstractMigrationRunnable {
    public MigrationRunnable(IFile file) {
        super(file);
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    protected boolean isTrackedResource(Resource resource) {
        return true;
    }

    protected IStatus preMigrationExecute(IResource fileToMigrate, MigrationContext context, boolean checkVersion) {
        return Status.OK_STATUS;
    }

    protected void postMigrationExecuteCommands(ExecutionManager executionManager, ResourceSet resourceSet, MigrationContext context) {
    }

    protected void preSaveResource(ExecutionManager executionManager, Resource resource, MigrationContext context) {
    }

    protected void postDispose(ExecutionManager executionManager, ResourceSet resourceSet, MigrationContext context) {
    }

    protected void newResource(Resource resource, MigrationContext context) {
    }

    @Override
    public IStatus run(MigrationContext context, boolean checkVersion) {
        LongRunningListenersRegistry.getInstance().operationStarting(this.getClass());
        context.setResource(this.getFile());
        IStatus result = this.preMigrationExecute((IResource)this._file, context, checkVersion);
        if (!result.isOK()) {
            return result;
        }
        ExecutionManager executionManager = ExecutionManagerRegistry.getInstance().addNewManager();
        IProgressMonitor monitor = context.getProgressMonitor();
        monitor.setTaskName(this.getName());
        monitor.beginTask(this.getName(), 100);
        if (executionManager == null) {
            return Status.CANCEL_STATUS;
        }
        ResourceSet resourceSet = executionManager.getEditingDomain().getResourceSet();
        resourceSet.setResourceFactoryRegistry(this.createLocalResourceFactory(context));
        this.registerExtendedMetaData(resourceSet, context);
        TrackingModificationAdapter trackingModificationAdapter = new TrackingModificationAdapter();
        resourceSet.eAdapters().add((Object)trackingModificationAdapter);
        try {
            try {
                if (result.isOK()) {
                    context.setProgressMonitor((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)40));
                    result = this.performLoadResources(this.getFile(), executionManager, resourceSet, context);
                }
                if (result.isOK()) {
                    context.setProgressMonitor((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)40));
                    result = this.performPostMigrationExecute(executionManager, resourceSet, context);
                }
                if (result.isOK()) {
                    context.setProgressMonitor((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)20));
                    result = this.performSaveResources(executionManager, resourceSet, context);
                }
            }
            catch (OutOfMemoryError error) {
                MigrationHelpers.getInstance().onOutOfMemoryError(error, context);
                throw error;
            }
        }
        finally {
            this.dispose(executionManager, resourceSet, context);
            monitor.done();
        }
        return result;
    }

    public abstract XMLResource doCreateResource(URI var1, MigrationContext var2);

    protected Resource.Factory.Registry createLocalResourceFactory(final MigrationContext context) {
        ResourceFactoryRegistryImpl localResourceFactoryRegistry = new ResourceFactoryRegistryImpl(){
            private Resource.Factory _factory;

            public Resource.Factory delegatedGetFactory(URI uri) {
                Resource.Factory result = null;
                if (MigrationRunnable.this.isHandledUri(uri)) {
                    if (this._factory == null) {
                        this._factory = new ResourceFactoryImpl(){

                            public Resource createResource(URI uri2) {
                                XMLResource resource = MigrationRunnable.this.doCreateResource(uri2, context);
                                if (resource == null) {
                                    resource = Resource.Factory.Registry.INSTANCE.getFactory(uri2).createResource(uri2);
                                }
                                MigrationRunnable.this.newResource((Resource)resource, context);
                                return resource;
                            }
                        };
                    }
                    result = this._factory;
                } else {
                    result = Resource.Factory.Registry.INSTANCE.getFactory(uri);
                }
                return result;
            }
        };
        return localResourceFactoryRegistry;
    }

    protected boolean isHandledUri(URI uri) {
        return true;
    }

    protected void registerExtendedMetaData(ResourceSet resourceSet, MigrationContext context) {
    }

    protected IStatus performLoadResources(final IFile modelFileToMigrate, ExecutionManager executionManager, final ResourceSet resourceSet, final MigrationContext context) {
        final IStatus[] result = new IStatus[]{Status.OK_STATUS};
        executionManager.execute((ICommand)new AbstractReadWriteCommand(){

            public void commandRolledBack() {
                result[0] = new Status(4, "org.polarsys.capella.core.data.migration", 1, this.getName(), null);
            }

            public void run() {
                context.getProgressMonitor().beginTask(Messages.MigrationAction_Command_LoadResources, 1);
                context.getProgressMonitor().subTask(Messages.MigrationAction_Command_LoadResources);
                try {
                    try {
                        resourceSet.getResource(FileHelper.getFileFullUri((String)modelFileToMigrate.getFullPath().toString()), true);
                        int resourcesCount = resourceSet.getResources().size();
                        int previousResourcesCount = 0;
                        while (resourcesCount != previousResourcesCount) {
                            previousResourcesCount = resourcesCount;
                            EcoreUtil.resolveAll((ResourceSet)resourceSet);
                            resourcesCount = resourceSet.getResources().size();
                        }
                        result[0] = MigrationRunnable.this.analyseResourceSet(resourceSet);
                        context.getProgressMonitor().worked(1);
                    }
                    catch (Exception exception) {
                        result[0] = CapellaSessionHelper.handleLoadingErrors((Exception)exception);
                        context.getProgressMonitor().done();
                    }
                }
                finally {
                    context.getProgressMonitor().done();
                }
            }
        });
        return result[0];
    }

    protected IStatus analyseResourceSet(ResourceSet resourceSet) {
        return Status.OK_STATUS;
    }

    protected IStatus performPostMigrationExecute(final ExecutionManager executionManager, final ResourceSet resourceSet, final MigrationContext context) {
        final IStatus[] result = new IStatus[]{Status.OK_STATUS};
        executionManager.execute((ICommand)new AbstractReadWriteCommand(){

            public void commandRolledBack() {
                result[0] = new Status(4, "org.polarsys.capella.core.data.migration", 1, this.getName(), null);
            }

            public void run() {
                try {
                    try {
                        context.getProgressMonitor().beginTask(Messages.MigrationAction_Command_ProcessingMigration, 1);
                        context.getProgressMonitor().subTask(Messages.MigrationAction_Command_ProcessingMigration);
                        MigrationRunnable.this.postMigrationExecute(executionManager, resourceSet, context);
                        context.getProgressMonitor().worked(1);
                    }
                    catch (Exception exception) {
                        result[0] = new Status(4, "org.polarsys.capella.core.data.migration", 1, String.valueOf(this.getName()) + ": " + exception.getMessage(), (Throwable)exception);
                        context.getProgressMonitor().done();
                    }
                }
                finally {
                    context.getProgressMonitor().done();
                }
            }
        });
        this.postMigrationExecuteCommands(executionManager, resourceSet, context);
        return result[0];
    }

    protected IStatus performSaveResources(final ExecutionManager executionManager, final ResourceSet resourceSet, final MigrationContext context) {
        final IStatus[] result = new IStatus[]{Status.OK_STATUS};
        executionManager.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                try {
                    if (Status.OK_STATUS != result[0]) {
                        return;
                    }
                    try {
                        context.getProgressMonitor().beginTask(Messages.MigrationAction_Command_SaveResources, resourceSet.getResources().size());
                        context.getProgressMonitor().subTask(Messages.MigrationAction_Command_SaveResources);
                        for (Resource resource : resourceSet.getResources()) {
                            if (resource.isModified() && resource.getURI().isPlatformResource()) {
                                context.getProgressMonitor().subTask(NLS.bind((String)Messages.MigrationAction_Command_SaveResource, (Object)resource.getURI().toString()));
                                MigrationRunnable.this.preSaveResource(executionManager, resource, context);
                                IUserEnforcedHelper userEnforcedHelper = SolFaCommonActivator.getDefault().getUserEnforcedHelper();
                                userEnforcedHelper.makeFileWritable(EcoreUtil2.getFile((Resource)resource));
                                resource.save(Collections.emptyMap());
                            }
                            context.getProgressMonitor().worked(1);
                        }
                    }
                    catch (Exception exception) {
                        result[0] = new Status(4, "org.polarsys.capella.core.data.migration", 1, String.valueOf(this.getName()) + ": " + exception.getMessage(), (Throwable)exception);
                    }
                }
                finally {
                    context.getProgressMonitor().done();
                }
            }
        });
        return result[0];
    }

    protected void postMigrationExecute(ExecutionManager executionManager, ResourceSet resourceSet, MigrationContext context) throws IOException {
    }

    protected void dispose(ExecutionManager executionManager, ResourceSet resourceSet, MigrationContext context) {
        ExecutionManagerRegistry.getInstance().removeManager(executionManager);
        TransactionalEditingDomain editingDomain = executionManager.getEditingDomain();
        EList resources = resourceSet.getResources();
        for (Resource resource : resources) {
            resource.unload();
            resource.eAdapters().clear();
        }
        editingDomain.dispose();
        if (editingDomain.getCommandStack() != null && editingDomain.getCommandStack() instanceof InternalTransactionalCommandStack) {
            ((InternalTransactionalCommandStack)editingDomain.getCommandStack()).dispose();
        }
        resources.clear();
        this.postDispose(executionManager, resourceSet, context);
        LongRunningListenersRegistry.getInstance().operationEnded(this.getClass());
    }

    class TrackingModificationAdapter
    extends EContentAdapter {
        TrackingModificationAdapter() {
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            Object notifier = notification.getNotifier();
            Resource resource = null;
            if (notifier instanceof EObject) {
                resource = ((EObject)notifier).eResource();
            } else if (notifier instanceof Resource) {
                resource = (Resource)notifier;
            }
            if (resource == null || resource.getURI().isPlatformPlugin()) {
                return;
            }
            if (!MigrationRunnable.this.isTrackedResource(resource)) {
                return;
            }
            switch (notification.getEventType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.setResourceAsModified(resource);
                }
            }
        }

        private void setResourceAsModified(Resource resource) {
            if (!resource.isModified()) {
                resource.setModified(true);
            }
        }
    }
}

