/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.core.validation.constraint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.data.core.validation.constraint.Messages;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class ReferentialConstraintsValidationRule
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        boolean validateIncoming;
        ArrayList<IStatus> results = new ArrayList<IStatus>();
        Collection<Object> targets = null;
        if (ctx.getEventType() == EMFEventType.NULL) {
            validateIncoming = false;
            targets = Collections.singleton(ctx.getTarget());
        } else {
            validateIncoming = true;
            targets = new ArrayList();
            for (Notification notification : ctx.getAllEvents()) {
                if (!(notification.getNotifier() instanceof EObject)) continue;
                ctx.skipCurrentConstraintFor((EObject)notification.getNotifier());
                if (!(notification.getFeature() instanceof EReference) || !((EReference)notification.getFeature()).isContainment()) continue;
                if (notification.getEventType() == 4) {
                    EObject e = (EObject)notification.getOldValue();
                    if (e.eResource() == null) continue;
                    targets.add(e);
                    continue;
                }
                if (notification.getEventType() != 6) continue;
                Collection removed = (Collection)notification.getOldValue();
                for (EObject e : removed) {
                    if (e.eResource() == null) continue;
                    targets.add(e);
                }
            }
        }
        for (EObject eObject : targets) {
            if (validateIncoming) {
                this.validateIncomingReferences(eObject, results, ctx);
            }
            this.validateOutgoingReferences(eObject, results, ctx);
        }
        if (results.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        IStatus iStatus = ConstraintStatus.createMultiStatus((IValidationContext)ctx, (String)Messages.I_37_ReferenceConstraints_title, (Object[])new Object[0], results);
        return iStatus;
    }

    private void validateOutgoingReferences(EObject element, Collection<IStatus> results, IValidationContext ctx) {
        EContentsEList.FeatureIterator it = (EContentsEList.FeatureIterator)element.eCrossReferences().iterator();
        while (it.hasNext()) {
            EObject target = (EObject)it.next();
            EReference ref = (EReference)it.feature();
            this.validateSetting(element, ref, target, results, ctx);
        }
        for (EObject e : element.eContents()) {
            this.validateOutgoingReferences(e, results, ctx);
        }
    }

    private void validateIncomingReferences(EObject element, Collection<IStatus> results, IValidationContext ctx) {
        SemanticEditingDomainFactory.SemanticEditingDomain domain = (SemanticEditingDomainFactory.SemanticEditingDomain)TransactionUtil.getEditingDomain((EObject)element);
        for (EStructuralFeature.Setting s : domain.getCrossReferencer().getInverseReferences(element)) {
            EObject source = s.getEObject();
            EReference ref = (EReference)s.getEStructuralFeature();
            if (ref.isContainment() || ref.isContainer()) continue;
            this.validateSetting(source, ref, element, results, ctx);
        }
        for (EObject e : element.eContents()) {
            this.validateIncomingReferences(e, results, ctx);
        }
    }

    private void validateSetting(EObject source, EReference ref, EObject target, Collection<IStatus> results, IValidationContext ctx) {
        List availableElements;
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(source.eClass(), (EStructuralFeature)ref);
        if (query != null && !(availableElements = query.getAvailableElements(source)).contains(target)) {
            results.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, Arrays.asList(source, target), (String)Messages.I_37_ReferenceConstraints_detail, (Object[])new Object[]{EObjectLabelProviderHelper.getText((EObject)source), EObjectLabelProviderHelper.getText((EObject)target), ref.getName()}));
        }
    }
}

