/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.fb.interpreter.mm.Permutations;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.CreateRecordedServiceSequenceCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.handler.ServiceHandlerUtils;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateAllServiceSequencesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        FBType fbtype = ServiceHandlerUtils.getSelectedFbType(null, selection);
        CompoundCommand createSequences = CreateAllServiceSequencesHandler.createAllSequences(fbtype);
        if (createSequences.canExecute()) {
            CommandStack cmdstack = (CommandStack)HandlerUtil.getActiveEditor((ExecutionEvent)event).getAdapter(CommandStack.class);
            cmdstack.execute((Command)createSequences);
        }
        return Status.OK_STATUS;
    }

    static CompoundCommand createAllSequences(FBType fbtype) {
        Object[] events = (Event[])fbtype.getInterfaceList().getEventInputs().toArray((Object[])new Event[0]);
        List allCombinationsSimple = Permutations.permute((Object[])events);
        CompoundCommand createSequences = new CompoundCommand();
        if (fbtype instanceof BasicFBType) {
            BasicFBType basic = (BasicFBType)fbtype;
            List<InputObject> combinations = CreateAllServiceSequencesHandler.getAllCombinationsWithStartStates(allCombinationsSimple, (EList<ECState>)basic.getECC().getECState());
            for (InputObject obj : combinations) {
                CreateRecordedServiceSequenceCommand cmd = new CreateRecordedServiceSequenceCommand(fbtype, obj.getEventNames(), Collections.emptyList());
                cmd.setStartState(obj.getStartState().getName());
                createSequences.add((Command)cmd);
            }
        } else {
            allCombinationsSimple.forEach(eventList -> {
                CreateRecordedServiceSequenceCommand cmd = new CreateRecordedServiceSequenceCommand(fbtype, eventList.stream().map(INamedElement::getName).toList(), Collections.emptyList());
                createSequences.add((Command)cmd);
            });
        }
        return createSequences;
    }

    public void setEnabled(Object evaluationContext) {
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            this.setBaseEnabled(ServiceHandlerUtils.getSelectedFbType(null, (IStructuredSelection)structuredSelection) != null);
        }
    }

    private static List<InputObject> getAllCombinationsWithStartStates(List<List<Event>> allCombinationsSimple, EList<ECState> states) {
        ArrayList<InputObject> combinations = new ArrayList<InputObject>();
        for (List<Event> events : allCombinationsSimple) {
            for (ECState state : states) {
                combinations.add(new InputObject(events.stream().map(Event.class::cast).toList(), state));
            }
        }
        return combinations;
    }

    static class InputObject {
        private final List<Event> events;
        private final ECState startState;

        public InputObject(List<Event> events, ECState startState) {
            this.events = events;
            this.startState = startState;
        }

        public List<Event> getEvents() {
            return this.events;
        }

        public ECState getStartState() {
            return this.startState;
        }

        public List<String> getEventNames() {
            return this.events.stream().map(INamedElement::getName).toList();
        }
    }
}

