/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.resource;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.xtext.linking.impl.ImportedNamesAdapter;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.impl.DefaultResourceDescription;
import org.eclipse.xtext.util.IResourceScopeCache;

public class STCoreResourceDescription
extends DefaultResourceDescription {
    private final IQualifiedNameConverter nameConverter;
    private Iterable<QualifiedName> importedNames;

    public STCoreResourceDescription(Resource resource, IDefaultResourceDescriptionStrategy strategy, IResourceScopeCache cache, IQualifiedNameConverter nameConverter) {
        super(resource, strategy, cache);
        this.nameConverter = nameConverter;
    }

    public Iterable<QualifiedName> getImportedNames() {
        if (this.importedNames == null) {
            this.importedNames = this.computeImportedNames();
        }
        return this.importedNames;
    }

    protected Set<QualifiedName> computeImportedNames() {
        HashSet<QualifiedName> result = new HashSet<QualifiedName>();
        TreeIterator allContents = EcoreUtil.getAllContents((Resource)this.getResource(), (boolean)true);
        while (allContents.hasNext()) {
            this.computeImportedNames((EObject)allContents.next(), result);
        }
        super.getImportedNames().forEach(result::add);
        return result;
    }

    protected void computeImportedNames(EObject object, Set<QualifiedName> result) {
        if (object instanceof Import) {
            Import imp = (Import)object;
            this.computeImportedNames(imp, result);
        }
    }

    protected void computeImportedNames(Import imp, Set<QualifiedName> result) {
        QualifiedName imported = this.nameConverter.toQualifiedName(imp.getImportedNamespace());
        if (!"*".equals(imported.getLastSegment())) {
            result.add(imported.toLowerCase());
        }
    }

    protected static Set<QualifiedName> getImportedNames(Resource resource) {
        EcoreUtil.resolveAll((Resource)resource);
        ImportedNamesAdapter adapter = ImportedNamesAdapter.find((Resource)resource);
        if (adapter != null) {
            return adapter.getImportedNames();
        }
        return Collections.emptySet();
    }

    protected IQualifiedNameConverter getNameConverter() {
        return this.nameConverter;
    }
}

