/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.delegate;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.delegate.InvocationBehavior;
import org.eclipse.ocl.ecore.delegate.OCLDelegateDomain;
import org.eclipse.ocl.ecore.delegate.OCLDelegateException;
import org.eclipse.ocl.ecore.delegate.ValidationBehavior;
import org.eclipse.ocl.ecore.delegate.ValidationDelegate;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.osgi.util.NLS;

public class OCLValidationDelegate
implements ValidationDelegate {
    protected final OCLDelegateDomain delegateDomain;
    protected final EClassifier eClassifier;

    public OCLValidationDelegate(OCLDelegateDomain delegateDomain, EClassifier classifier) {
        this.delegateDomain = delegateDomain;
        this.eClassifier = classifier;
    }

    protected boolean check(Object object, String constraint, OCLExpression query) {
        OCL ocl = this.delegateDomain.getOCL();
        OCLStandardLibrary stdlib = ocl.getEnvironment().getOCLStandardLibrary();
        if (query.getType() != stdlib.getBoolean()) {
            String message = NLS.bind((String)OCLMessages.ValidationConstraintIsNotBoolean_ERROR_, (Object)constraint);
            throw new OCLDelegateException(message);
        }
        Object result = ocl.evaluate(object, query);
        if (ocl.isInvalid(result)) {
            String message = NLS.bind((String)OCLMessages.ValidationResultIsInvalid_ERROR_, (Object)constraint);
            throw new OCLDelegateException(message);
        }
        if (result == null) {
            String message = NLS.bind((String)OCLMessages.ValidationResultIsNull_ERROR_, (Object)constraint);
            throw new OCLDelegateException(message);
        }
        if (!(result instanceof Boolean)) {
            String message = NLS.bind((String)OCLMessages.ValidationResultIsNotBoolean_ERROR_, (Object)constraint);
            throw new OCLDelegateException(message);
        }
        return Boolean.TRUE.equals(result);
    }

    protected OCLExpression createQuery(String expression) {
        OCL ocl = this.delegateDomain.getOCL();
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext(this.eClassifier);
        try {
            return helper.createQuery(expression);
        }
        catch (ParserException e) {
            throw new OCLDelegateException(e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    public String toString() {
        return "<" + this.delegateDomain.getURI() + ":validate> " + this.eClassifier.getEPackage().getName() + "::" + this.eClassifier.getName();
    }

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> context, EOperation invariant, String expression) {
        OCLExpression query = InvocationBehavior.INSTANCE.getOperationBody(this.delegateDomain.getOCL(), invariant);
        if (query == null) {
            query = this.createQuery(expression);
            InvocationBehavior.INSTANCE.cacheOCLExpression(invariant, query);
        }
        return this.check(eObject, invariant.getName(), query);
    }

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> context, String constraint, String expression) {
        OCLExpression query = ValidationBehavior.INSTANCE.getInvariant((EClassifier)eClass, constraint, this.delegateDomain.getOCL());
        if (query == null) {
            query = this.createQuery(expression);
            ValidationBehavior.INSTANCE.cacheOCLExpression((EClassifier)eClass, constraint, query);
        }
        return this.check(eObject, constraint, query);
    }

    public boolean validate(EDataType eDataType, Object value, Map<Object, Object> context, String constraint, String expression) {
        OCLExpression query = ValidationBehavior.INSTANCE.getInvariant((EClassifier)eDataType, constraint, this.delegateDomain.getOCL());
        if (query == null) {
            query = this.createQuery(expression);
            ValidationBehavior.INSTANCE.cacheOCLExpression((EClassifier)eDataType, constraint, query);
        }
        return this.check(value, constraint, query);
    }
}

