/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.assist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sirius.common.tools.api.contentassist.IProposalProvider;
import org.eclipse.sirius.common.tools.api.interpreter.CompoundInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.internal.assist.ProposalProviderDescriptor;

public final class ProposalProviderRegistry {
    private static final List<ProposalProviderDescriptor> DESCRIPTORS = new ArrayList<ProposalProviderDescriptor>();

    private ProposalProviderRegistry() {
    }

    public static void addProvider(ProposalProviderDescriptor descriptor) {
        DESCRIPTORS.add(descriptor);
    }

    public static void clearRegistry() {
        DESCRIPTORS.clear();
    }

    public static List<IProposalProvider> getAllProviders() {
        ArrayList<IProposalProvider> providers = new ArrayList<IProposalProvider>();
        for (ProposalProviderDescriptor descriptor : DESCRIPTORS) {
            providers.add(descriptor.createProposalProvider());
        }
        return providers;
    }

    public static List<IProposalProvider> getProvidersFor(IInterpreter interpreter) {
        if (interpreter == null) {
            return Collections.emptyList();
        }
        String interpreterID = CompoundInterpreter.INSTANCE.getInterpreterID(interpreter);
        List<IProposalProvider> providers = interpreterID != null ? ProposalProviderRegistry.getProvidersFor(interpreterID) : Collections.emptyList();
        return providers;
    }

    public static List<IProposalProvider> getProvidersFor(String interpreter) {
        if (interpreter == null || interpreter.length() <= 0) {
            return Collections.emptyList();
        }
        ArrayList<IProposalProvider> providers = new ArrayList<IProposalProvider>();
        for (ProposalProviderDescriptor descriptor : DESCRIPTORS) {
            IProposalProvider provider;
            if (!interpreter.equals(descriptor.getInterpreter()) || (provider = descriptor.createProposalProvider()) == null) continue;
            providers.add(provider);
        }
        return providers;
    }

    public static void removeProvider(String className) {
        for (ProposalProviderDescriptor descriptor : new ArrayList<ProposalProviderDescriptor>(DESCRIPTORS)) {
            if (!className.equals(descriptor.getClassName())) continue;
            DESCRIPTORS.remove(descriptor);
        }
    }
}

