/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.contentprovider.ECCContentAndLabelProvider;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.gef.commands.Command;

public class ChangeConditionEventCommand
extends Command
implements ScopedCommand {
    private final ECTransition transition;
    private final List<Event> eventList = new ArrayList<Event>();
    private final String conditionEvent;
    private String oldConditionEvent;
    private String oldConditionExpression;

    public ChangeConditionEventCommand(ECTransition transition, String conditionEvent) {
        this.transition = Objects.requireNonNull(transition);
        this.conditionEvent = conditionEvent;
        BasicFBType fb = transition != null ? transition.getECC().getBasicFBType() : null;
        this.eventList.addAll(ECCContentAndLabelProvider.getInputEvents(fb));
    }

    public boolean canExecute() {
        return this.conditionEvent.equals(ECCContentAndLabelProvider.EMPTY_FIELD) || this.conditionEvent.contentEquals("1") || !this.eventList.isEmpty();
    }

    public void execute() {
        String string = this.oldConditionEvent = this.transition.getConditionEvent() != null ? this.transition.getConditionEvent().getName() : "";
        if ("1".equals(this.conditionEvent)) {
            this.oldConditionExpression = this.transition.getConditionExpression();
        }
        if ("1".equals(this.transition.getConditionExpression())) {
            this.oldConditionExpression = this.transition.getConditionExpression();
            this.transition.setConditionExpression("");
        }
        this.redo();
    }

    public void undo() {
        if (this.oldConditionExpression != null) {
            this.transition.setConditionExpression(this.oldConditionExpression);
        }
        this.transition.setConditionEvent(this.getEvent(this.oldConditionEvent));
    }

    public void redo() {
        if (this.conditionEvent.equals("1")) {
            this.transition.setConditionExpression("1");
            this.transition.setConditionEvent(null);
        } else {
            this.transition.setConditionEvent(this.getEvent(this.conditionEvent));
        }
    }

    private Event getEvent(String eventName) {
        for (Event e : this.eventList) {
            if (!ECCContentAndLabelProvider.getEventName(e).equals(eventName)) continue;
            return e;
        }
        return null;
    }

    public Set<EObject> getAffectedObjects() {
        return Set.of(this.transition);
    }
}

