/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.libraryElement;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Language implements Enumerator
{
    C(0, "C", "C"),
    OTHER(1, "Other", "Other"),
    JAVA(2, "Java", "Java"),
    CPP(3, "Cpp", "Cpp");

    public static final int C_VALUE = 0;
    public static final int OTHER_VALUE = 1;
    public static final int JAVA_VALUE = 2;
    public static final int CPP_VALUE = 3;
    private static final Language[] VALUES_ARRAY;
    public static final List<Language> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Language[]{C, OTHER, JAVA, CPP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Language get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Language result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Language getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Language result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Language get(int value) {
        switch (value) {
            case 0: {
                return C;
            }
            case 1: {
                return OTHER;
            }
            case 2: {
                return JAVA;
            }
            case 3: {
                return CPP;
            }
        }
        return null;
    }

    private Language(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

