/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.command;

import com.google.common.collect.ForwardingObject;
import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;

public abstract class DelegatingCommandStack
extends ForwardingObject
implements CommandStack {
    private final List<CommandStackListener> listeners = Lists.newArrayList();

    protected abstract CommandStack delegate();

    public void execute(Command command) {
        this.delegate().execute(command);
    }

    public boolean canUndo() {
        return this.delegate().canUndo();
    }

    public void undo() {
        this.delegate().undo();
    }

    public boolean canRedo() {
        return this.delegate().canRedo();
    }

    public Command getUndoCommand() {
        return this.delegate().getUndoCommand();
    }

    public Command getRedoCommand() {
        return this.delegate().getRedoCommand();
    }

    public Command getMostRecentCommand() {
        return this.delegate().getMostRecentCommand();
    }

    public void redo() {
        this.delegate().redo();
    }

    public void flush() {
        this.delegate().flush();
    }

    public void addCommandStackListener(CommandStackListener listener) {
        this.listeners.add(listener);
    }

    public void removeCommandStackListener(CommandStackListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners(Object source) {
        for (CommandStackListener commandStackListener : this.listeners) {
            commandStackListener.commandStackChanged(new EventObject(source));
        }
    }
}

