/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.application.editparts.HiddenPinIndicator;
import org.eclipse.fordiac.ide.ui.preferences.UIPreferenceConstants;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class HiddenPinIndicatorEditPart
extends AbstractGraphicalEditPart {
    protected IFigure createFigure() {
        FordiacTriangle triangle = new FordiacTriangle(((HiddenPinIndicator)super.getModel()).isInput());
        triangle.setBorder((Border)new MarginBorder(3));
        triangle.setBounds(new Rectangle(0, 0, 15, 15));
        triangle.setBackgroundColor(UIPreferenceConstants.getAnyIntConnectorColor());
        triangle.setOutline(false);
        return triangle;
    }

    protected void createEditPolicies() {
    }

    public static final class FordiacTriangle
    extends Shape {
        private boolean isInput = true;
        private final PointList triangle = new PointList(3);

        public FordiacTriangle(boolean isInput) {
            this.isInput = isInput;
        }

        protected void fillShape(Graphics g) {
            g.fillPolygon(this.triangle);
        }

        protected void outlineShape(Graphics g) {
            g.drawPolygon(this.triangle);
        }

        public void primTranslate(int dx, int dy) {
            super.primTranslate(dx, dy);
            this.triangle.translate(dx, dy);
        }

        public void validate() {
            Point p3;
            Point p2;
            Point head;
            super.validate();
            Rectangle r = new Rectangle();
            r.setBounds(this.getBounds());
            r.shrink(this.getInsets());
            r.resize(-1, -1);
            int size = Math.min(r.height, r.width);
            size = Math.max(size, 1);
            if (this.isInput) {
                head = new Point(r.x, r.y);
                p2 = new Point(head.x, head.y + size);
                p3 = new Point(head.x + size, head.y + size);
            } else {
                head = new Point(r.x + size, r.y);
                p2 = new Point(head.x, head.y + size);
                p3 = new Point(head.x - size, head.y + size);
            }
            this.triangle.removeAllPoints();
            this.triangle.addPoint(head);
            this.triangle.addPoint(p2);
            this.triangle.addPoint(p3);
        }
    }
}

