/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.policies;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.commands.BorderCrossingReconnectCommand;
import org.eclipse.fordiac.ide.application.commands.CreateSubAppCrossingConnectionsCommand;
import org.eclipse.fordiac.ide.gef.FixedAnchor;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.commands.change.AbstractReconnectConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public abstract class InterfaceElementEditPolicy
extends GraphicalNodeEditPolicy {
    public InterfaceEditPart getHost() {
        return (InterfaceEditPart)super.getHost();
    }

    protected final Command getConnectionCreateCommand(CreateConnectionRequest request) {
        AbstractConnectionCreateCommand command = this.createConnectionCreateCommand();
        if (command != null) {
            command.setSource(this.getHost().getModel());
        }
        request.setStartCommand((Command)command);
        return command;
    }

    protected abstract AbstractConnectionCreateCommand createConnectionCreateCommand();

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        AbstractConnectionCreateCommand command = (AbstractConnectionCreateCommand)request.getStartCommand();
        command.setDestination(this.getHost().getModel());
        FBNetwork newParent = InterfaceElementEditPolicy.checkConnectionParent(command.getSource(), command.getDestination(), command.getParent());
        if (newParent != null) {
            command.setParent(newParent);
            return command;
        }
        return CreateSubAppCrossingConnectionsCommand.createProcessBorderCrossingConnection(command.getSource(), command.getDestination());
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        return this.createReconnectCommand(request, false);
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        return this.createReconnectCommand(request, true);
    }

    private Command createReconnectCommand(ReconnectRequest request, boolean isSourceReconnect) {
        Connection conn = (Connection)request.getConnectionEditPart().getModel();
        IInterfaceElement sourcePin = conn.getSource();
        IInterfaceElement targetPin = conn.getDestination();
        IInterfaceElement newPin = this.getHost().getModel();
        if (isSourceReconnect && InterfaceElementEditPolicy.isBorderCrossing(newPin, targetPin, conn.getFBNetwork())) {
            return new BorderCrossingReconnectCommand(newPin, targetPin, conn, true);
        }
        if (!isSourceReconnect && InterfaceElementEditPolicy.isBorderCrossing(newPin, sourcePin, conn.getFBNetwork())) {
            return new BorderCrossingReconnectCommand(sourcePin, newPin, conn, false);
        }
        AbstractReconnectConnectionCommand cmd = this.createReconnectCommand(conn, isSourceReconnect, newPin);
        FBNetwork newParent = InterfaceElementEditPolicy.checkConnectionParent(cmd.getNewSource(), cmd.getNewDestination(), cmd.getParent());
        if (newParent != null) {
            cmd.setParent(newParent);
            return cmd;
        }
        return null;
    }

    private static boolean isBorderCrossing(IInterfaceElement srcPin, IInterfaceElement destPin, FBNetwork fbNetwork) {
        return InterfaceElementEditPolicy.checkConnectionParent(srcPin, destPin, fbNetwork) == null;
    }

    protected FBNetwork getParentNetwork() {
        return (FBNetwork)this.getHost().getRoot().getAdapter(FBNetwork.class);
    }

    protected abstract AbstractReconnectConnectionCommand createReconnectCommand(Connection var1, boolean var2, IInterfaceElement var3);

    private static FBNetwork checkConnectionParent(IInterfaceElement source, IInterfaceElement destination, FBNetwork parent) {
        FBNetwork srcParent = InterfaceElementEditPolicy.getFBNetwork4Pin(source);
        FBNetwork dstParent = InterfaceElementEditPolicy.getFBNetwork4Pin(destination);
        if (srcParent != null && dstParent != null) {
            SubApp subapp;
            SubApp subapp2;
            if (srcParent == dstParent) {
                return InterfaceElementEditPolicy.checkParentInSameNetwork(source, destination, parent, srcParent);
            }
            BlockFBNetworkElement blockFBNetworkElement = source.getBlockFBNetworkElement();
            if (blockFBNetworkElement instanceof SubApp && (subapp2 = (SubApp)blockFBNetworkElement).getSubAppNetwork() == dstParent) {
                return dstParent;
            }
            BlockFBNetworkElement blockFBNetworkElement2 = destination.getBlockFBNetworkElement();
            if (blockFBNetworkElement2 instanceof SubApp && (subapp = (SubApp)blockFBNetworkElement2).getSubAppNetwork() == srcParent) {
                return srcParent;
            }
        }
        return null;
    }

    private static FBNetwork checkParentInSameNetwork(IInterfaceElement src, IInterfaceElement dest, FBNetwork parent, FBNetwork srcParent) {
        SubApp subApp;
        BlockFBNetworkElement blockFBNetworkElement = src.getBlockFBNetworkElement();
        if (blockFBNetworkElement instanceof SubApp) {
            SubApp destSubApp;
            SubApp srcSubApp = (SubApp)blockFBNetworkElement;
            BlockFBNetworkElement blockFBNetworkElement2 = dest.getBlockFBNetworkElement();
            if (blockFBNetworkElement2 instanceof SubApp && srcSubApp == (destSubApp = (SubApp)blockFBNetworkElement2) && !srcSubApp.isTyped() && srcSubApp.getSubAppNetwork() != parent) {
                if (src.isIsInput()) {
                    return srcSubApp.getSubAppNetwork();
                }
                return srcParent;
            }
        }
        if (srcParent == parent) {
            return parent;
        }
        BlockFBNetworkElement blockFBNetworkElement3 = src.getBlockFBNetworkElement();
        if (blockFBNetworkElement3 instanceof SubApp && (subApp = (SubApp)blockFBNetworkElement3).getSubAppNetwork() == parent) {
            return parent;
        }
        return srcParent;
    }

    private static FBNetwork getFBNetwork4Pin(IInterfaceElement pin) {
        if (pin != null) {
            if (pin.getBlockFBNetworkElement() != null) {
                return pin.getBlockFBNetworkElement().getFbNetwork();
            }
            EObject eObject = pin.eContainer().eContainer();
            if (eObject instanceof CompositeFBType) {
                CompositeFBType cfbType = (CompositeFBType)eObject;
                return cfbType.getFBNetwork();
            }
        }
        return null;
    }

    protected ConnectionAnchor getSourceConnectionAnchor(CreateConnectionRequest request) {
        SubApp subapp;
        BlockFBNetworkElement blockFBNetworkElement;
        IInterfaceElement ie = this.getHost().getModel();
        if (ie.isIsInput() && (blockFBNetworkElement = ie.getBlockFBNetworkElement()) instanceof SubApp && (subapp = (SubApp)blockFBNetworkElement).isUnfolded()) {
            return new FixedAnchor(this.getHostFigure(), false);
        }
        return super.getSourceConnectionAnchor(request);
    }
}

