/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.jface.gridviewer;

import org.eclipse.jface.layout.AbstractColumnLayout;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Widget;

public class GridColumnLayout
extends AbstractColumnLayout {
    private static final boolean IS_GTK = Util.isGtk();

    protected int getColumnCount(Scrollable tableTree) {
        return ((Grid)tableTree).getColumnCount();
    }

    protected void setColumnWidths(Scrollable tableTree, int[] widths) {
        GridColumn[] columns = ((Grid)tableTree).getColumns();
        int i = 0;
        while (i < widths.length) {
            columns[i].setWidth(widths[i]);
            ++i;
        }
    }

    protected ColumnLayoutData getLayoutData(Scrollable tableTree, int columnIndex) {
        GridColumn column = ((Grid)tableTree).getColumn(columnIndex);
        return (ColumnLayoutData)column.getData("org.eclipse.jface.LAYOUT_DATA");
    }

    Composite getComposite(Widget column) {
        return ((GridColumn)column).getParent().getParent();
    }

    protected void updateColumnData(Widget column) {
        GridColumn gColumn = (GridColumn)column;
        Grid g = gColumn.getParent();
        if (!IS_GTK || g.getColumn(g.getColumnCount() - 1) != gColumn) {
            gColumn.setData("org.eclipse.jface.LAYOUT_DATA", new ColumnPixelData(gColumn.getWidth()));
            this.layout(g.getParent(), true);
        }
    }
}

