/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.util;

import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSource;
import org.eclipse.fordiac.ide.structuredtextcore.util.STAbstractCorePartitioner;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCorePartition;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;

public abstract class STRecoveringPartitioner<E extends INamedElement>
extends STAbstractCorePartitioner<E> {
    public static final String LOST_AND_FOUND_NAME = "LOST_AND_FOUND";
    protected static final String LOST_AND_FOUND_NAME_PATTERN = "LOST_AND_FOUND_%s";
    public static final String LOST_AND_FOUND_COMMENT = "lost+found";
    protected static final String LOST_AND_FOUND_COMMENT_PATTERN = "lost+found %s";

    protected Optional<STCorePartition> emergencyPartition(XtextResource resource) {
        if (resource.getParseResult() != null && resource.getParseResult().getRootNode() != null) {
            String text = resource.getParseResult().getRootNode().getText();
            return Optional.of(this.createEmergencyPartition(text));
        }
        return Optional.empty();
    }

    protected Optional<STCorePartition> emergencyPartition(STSource source) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)source);
        if (node != null) {
            return Optional.of(this.createEmergencyPartition(node.getText()));
        }
        return Optional.empty();
    }

    protected void handleLostAndFound(ICompositeNode rootNode, List<? extends EObject> source, List<E> result) {
        int lastOffset = 0;
        int index = 0;
        while (index < source.size()) {
            EObject element = source.get(index);
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)element);
            int totalOffset = node.getTotalOffset();
            if (totalOffset > lastOffset) {
                this.handleLostAndFound(rootNode, index, lastOffset, totalOffset, result);
            }
            lastOffset = node.getTotalEndOffset();
            ++index;
        }
        int totalEndOffset = rootNode.getTotalEndOffset();
        if (totalEndOffset > lastOffset) {
            if (result.isEmpty()) {
                this.handleLostAndFound(rootNode, result.size(), lastOffset, totalEndOffset, result);
            } else {
                this.appendText((INamedElement)result.get(result.size() - 1), rootNode.getText().substring(lastOffset, totalEndOffset));
            }
        }
    }

    protected void handleLostAndFound(ICompositeNode rootNode, int index, int start, int end, List<E> result) {
        String text = rootNode.getText().substring(start, end);
        if (!text.isBlank()) {
            result.add(index, this.createLostAndFound(text, index));
        }
    }

    protected static String generateLostAndFoundName(int index) {
        return LOST_AND_FOUND_NAME_PATTERN.formatted(index);
    }

    protected static String generateLostAndFoundComment(int index) {
        return LOST_AND_FOUND_COMMENT_PATTERN.formatted(index);
    }

    protected abstract STCorePartition createEmergencyPartition(String var1);

    protected abstract E createLostAndFound(String var1, int var2);

    protected abstract void appendText(E var1, String var2);
}

