/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.nat;

import java.util.List;
import java.util.Objects;
import org.eclipse.fordiac.ide.gef.nat.AbstractColumnAccessor;
import org.eclipse.fordiac.ide.gef.nat.TypedElementTableColumn;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.edit.helper.CommentHelper;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.gef.commands.Command;

public class TypedElementColumnAccessor<T extends ITypedElement>
extends AbstractColumnAccessor<T, TypedElementTableColumn> {
    protected TypedElementColumnAccessor(CommandExecutor commandExecutor) {
        this(commandExecutor, TypedElementTableColumn.DEFAULT_COLUMNS);
    }

    protected TypedElementColumnAccessor(CommandExecutor commandExecutor, List<TypedElementTableColumn> columns) {
        super(commandExecutor, columns);
    }

    @Override
    public Object getDataValue(T rowObject, TypedElementTableColumn column) {
        return switch (column) {
            case TypedElementTableColumn.NAME -> rowObject.getName();
            case TypedElementTableColumn.TYPE -> rowObject.getFullTypeName();
            case TypedElementTableColumn.COMMENT -> CommentHelper.getInstanceComment(rowObject);
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)column));
        };
    }

    @Override
    public Command createCommand(T rowObject, TypedElementTableColumn column, Object newValue) {
        return switch (column) {
            case TypedElementTableColumn.NAME -> ChangeNameCommand.forName(rowObject, (String)Objects.toString(newValue, ""));
            case TypedElementTableColumn.TYPE -> throw new UnsupportedOperationException("Cannot change type");
            case TypedElementTableColumn.COMMENT -> new ChangeCommentCommand(rowObject, Objects.toString(newValue, ""));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)column));
        };
    }
}

