/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring;

import java.util.function.Consumer;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.ArrayType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STResource;
import org.eclipse.xtext.ide.serializer.impl.RelatedResourcesProvider;
import org.eclipse.xtext.ide.serializer.impl.ResourceLifecycleManager;

public class STCoreResourceLifecycleManager
extends ResourceLifecycleManager {
    public Resource openAndApplyReferences(ResourceSet resourceSet, RelatedResourcesProvider.RelatedResource toLoad) {
        Resource resource = super.openAndApplyReferences(resourceSet, toLoad);
        if (resource instanceof STResource) {
            STResource stResource = (STResource)resource;
            STCoreResourceLifecycleManager.updateType(stResource.getExpectedType(), arg_0 -> ((STResource)stResource).setExpectedType(arg_0), resourceSet);
        }
        STCoreResourceLifecycleManager.updateCrossReferences(resource, resourceSet);
        return resource;
    }

    protected static void updateCrossReferences(Resource resource, ResourceSet resourceSet) {
        TreeIterator contents = EcoreUtil.getAllContents((Resource)resource, (boolean)true);
        while (contents.hasNext()) {
            EObject next = (EObject)contents.next();
            if (!(next instanceof VarDeclaration)) continue;
            VarDeclaration varDeclaration = (VarDeclaration)next;
            STCoreResourceLifecycleManager.updateType(varDeclaration.getType(), arg_0 -> ((VarDeclaration)varDeclaration).setType(arg_0), resourceSet);
        }
    }

    protected static <T extends LibraryElement> void updateType(T type, Consumer<? super T> consumer, ResourceSet resourceSet) {
        if (type instanceof AnyDerivedType) {
            Class<T> clazz = STCoreResourceLifecycleManager.getClass(type);
            if (type.eResource() != null && type.eResource().getResourceSet() != resourceSet) {
                EObject canonicalObject = resourceSet.getEObject(EcoreUtil.getURI(type), true);
                if (clazz.isInstance(canonicalObject)) {
                    STCoreResourceLifecycleManager.updateCrossReferences(canonicalObject.eResource(), resourceSet);
                    consumer.accept(clazz.cast(canonicalObject));
                }
            } else if (type instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)type;
                STCoreResourceLifecycleManager.updateType(arrayType.getBaseType(), arg_0 -> ((ArrayType)arrayType).setBaseType(arg_0), resourceSet);
            }
        }
    }

    protected static <T> Class<? extends T> getClass(T type) {
        return type.getClass();
    }
}

