/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring;

import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.commands.change.ChangeValueCommand;
import org.eclipse.fordiac.ide.model.commands.change.ReconnectDataConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.change.ReconnectEventConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteInterfaceCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.typemanagement.refactoring.IFordiacPreviewChange;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

class ReconnectPinByName
extends Command {
    final String oldName;
    final String newName;
    final FBNetworkElement element;
    final CompoundCommand cmds = new CompoundCommand();
    private final Set<IFordiacPreviewChange.ChangeState> state;

    public ReconnectPinByName(String oldName, String newName, FBNetworkElement fbNeworkElement, Set<IFordiacPreviewChange.ChangeState> state) {
        this.oldName = oldName;
        this.newName = newName;
        this.element = fbNeworkElement;
        this.state = state;
    }

    public boolean canExecute() {
        return this.state.contains((Object)IFordiacPreviewChange.ChangeState.RECONNECT) || this.state.contains((Object)IFordiacPreviewChange.ChangeState.DELETE);
    }

    public void execute() {
        IInterfaceElement interfaceElement = this.element.getInterfaceElement(this.newName);
        IInterfaceElement oldinterfaceElement = this.element.getInterfaceElement(this.oldName);
        if (interfaceElement != null && oldinterfaceElement instanceof ErrorMarkerInterface) {
            ErrorMarkerInterface errorMarkerInterface = (ErrorMarkerInterface)oldinterfaceElement;
            this.propagateInitialValue(interfaceElement, oldinterfaceElement);
            for (Attribute attribute : oldinterfaceElement.getAttributes()) {
                interfaceElement.setAttribute(attribute.getName(), attribute.getType(), attribute.getValue(), attribute.getComment());
            }
            interfaceElement.setComment(oldinterfaceElement.getComment());
            EList<Connection> inputConnections = ReconnectPinByName.getConnection((IInterfaceElement)errorMarkerInterface);
            if (inputConnections.isEmpty()) {
                this.cmds.add((Command)new DeleteInterfaceCommand(oldinterfaceElement));
            } else if (this.state.contains((Object)IFordiacPreviewChange.ChangeState.RECONNECT)) {
                this.reconnect(interfaceElement, errorMarkerInterface, inputConnections);
            } else if (this.state.contains((Object)IFordiacPreviewChange.ChangeState.DELETE)) {
                this.deleteConnection(inputConnections);
            }
        }
        this.cmds.execute();
    }

    private void propagateInitialValue(IInterfaceElement interfaceElement, IInterfaceElement oldinterfaceElement) {
        ErrorMarkerInterface old;
        if (oldinterfaceElement instanceof ErrorMarkerInterface && (old = (ErrorMarkerInterface)oldinterfaceElement).getValue() != null && !old.getValue().getValue().isEmpty() && interfaceElement instanceof VarDeclaration) {
            VarDeclaration varDeclnew = (VarDeclaration)interfaceElement;
            this.cmds.add((Command)new ChangeValueCommand(varDeclnew, old.getValue().getValue()));
        }
    }

    private void deleteConnection(EList<Connection> inputConnections) {
        for (Connection c : inputConnections) {
            this.cmds.add((Command)new DeleteConnectionCommand(c));
        }
    }

    private void reconnect(IInterfaceElement interfaceElement, ErrorMarkerInterface errorMarkerInterface, EList<Connection> inputConnections) {
        for (Connection c : inputConnections) {
            this.reconnect(c, interfaceElement, errorMarkerInterface);
        }
    }

    private void reconnect(Connection c, IInterfaceElement interfaceElement, ErrorMarkerInterface errorMarkerInterface) {
        if (c instanceof DataConnection) {
            DataConnection dc = (DataConnection)c;
            ReconnectDataConnectionCommand cmd = new ReconnectDataConnectionCommand((Connection)dc, !errorMarkerInterface.isIsInput(), interfaceElement, this.element.getFbNetwork());
            this.cmds.add((Command)cmd);
        }
        if (c instanceof EventConnection) {
            EventConnection dc = (EventConnection)c;
            ReconnectEventConnectionCommand cmd = new ReconnectEventConnectionCommand((Connection)dc, !errorMarkerInterface.isIsInput(), interfaceElement, this.element.getFbNetwork());
            this.cmds.add((Command)cmd);
        }
    }

    private static EList<Connection> getConnection(IInterfaceElement iE) {
        return iE.isIsInput() ? iE.getInputConnections() : iE.getOutputConnections();
    }

    public boolean canUndo() {
        return this.cmds.canUndo();
    }

    public boolean canRedo() {
        return this.cmds.canRedo();
    }

    public void undo() {
        this.cmds.undo();
    }

    public void redo() {
        this.cmds.redo();
    }
}

