/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.move;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.systemmanagement.changelistener.FordiacResourceChangeListener;
import org.eclipse.fordiac.ide.typemanagement.refactoring.UpdateTypeEntryChange;
import org.eclipse.fordiac.ide.typemanagement.wizards.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.widgets.Shell;

public class UpdateTypeEntryFileChange
extends UpdateTypeEntryChange {
    private final IFile destinationFile;

    public UpdateTypeEntryFileChange(IFile currentFile, TypeEntry typeEntry, IFile destinationFile) {
        super(currentFile, typeEntry, typeEntry.getTypeName(), typeEntry.getTypeName());
        this.destinationFile = destinationFile;
    }

    @Override
    public String getName() {
        return Messages.MoveTypeToPackage_UpdateTypeEntryFile;
    }

    @Override
    protected boolean shouldSaveFile(Shell shell, String oldName) {
        int result = MessageDialog.open((int)3, (Shell)shell, (String)"Moving of Type with unsaved changes!", (String)MessageFormat.format("There are unsaved changes for type \"{0}\". Do you want to save them before moving it?", oldName), (int)0, (String[])new String[]{"Save", "Cancel"});
        return result == 0;
    }

    @Override
    public Change perform(IProgressMonitor pm) throws CoreException {
        if (this.destinationFile != null) {
            FordiacResourceChangeListener.updateTypeEntry((IFile)this.destinationFile, (TypeEntry)this.typeEntry);
            return new UpdateTypeEntryFileChange(this.destinationFile, this.typeEntry, this.file);
        }
        return null;
    }
}

