/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.ServiceConstants;
import org.eclipse.fordiac.ide.util.ColorManager;
import org.eclipse.swt.graphics.RGB;

public class PrimitiveFigure
extends Layer {
    private final Label nameLabel;
    private final Label emptyLabel;
    private final Label parameterLabel;
    private final Figure centerFigure;
    private final Figure leftFigure;
    private final Figure rightFigure;

    public PrimitiveFigure(boolean isLeftInterface, String name, String parameter) {
        GridLayout mainLayout = new GridLayout(6, false);
        this.setLayoutManager((LayoutManager)mainLayout);
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainLayout.horizontalSpacing = 0;
        this.nameLabel = new Label();
        this.nameLabel.setForegroundColor(ColorConstants.black);
        GridData nameLabelData = new GridData(4, 0x1000000, false, false);
        nameLabelData.widthHint = ServiceConstants.getNameLabelWidth();
        this.parameterLabel = new Label();
        this.parameterLabel.setForegroundColor(ColorManager.getColor((RGB)ServiceConstants.GRAY));
        GridData parameterLabelData = new GridData(4, 0x1000000, false, false);
        parameterLabelData.widthHint = ServiceConstants.getParameterLabelWidth();
        this.emptyLabel = new Label();
        GridData emptyLabelData = new GridData(4, 0x1000000, false, false);
        emptyLabelData.widthHint = ServiceConstants.getEmptyLabelWidth();
        GridData arrowLeftData = new GridData(4, 0x1000000, false, false);
        arrowLeftData.widthHint = ServiceConstants.getArrowWidth();
        this.leftFigure = new Figure();
        this.centerFigure = new Figure();
        GridData spaceData = new GridData(4, 0x1000000, false, false);
        spaceData.widthHint = ServiceConstants.getMiddleSectionWidth();
        GridData arrowRightData = new GridData(4, 0x1000000, false, false);
        arrowRightData.widthHint = ServiceConstants.getArrowWidth();
        this.rightFigure = new Figure();
        this.setInterfaceDirection(isLeftInterface);
        this.setNameLabelText(name);
        this.setParameterLabelText(parameter);
        this.setConstraint((IFigure)this.emptyLabel, emptyLabelData);
        this.setConstraint((IFigure)this.leftFigure, arrowLeftData);
        this.setConstraint((IFigure)this.centerFigure, spaceData);
        this.setConstraint((IFigure)this.rightFigure, arrowRightData);
        this.setConstraint((IFigure)this.nameLabel, nameLabelData);
        this.setConstraint((IFigure)this.parameterLabel, parameterLabelData);
    }

    public void setInterfaceDirection(boolean interfaceDirection) {
        if (!this.getChildren().isEmpty()) {
            this.getChildren().clear();
        }
        if (interfaceDirection) {
            this.nameLabel.setLabelAlignment(4);
            this.parameterLabel.setLabelAlignment(1);
            this.nameLabel.setBorder((Border)new MarginBorder(0, 0, 0, 10));
            this.add((IFigure)this.parameterLabel);
            this.add((IFigure)this.nameLabel);
            this.add((IFigure)this.leftFigure);
            this.add((IFigure)this.centerFigure);
            this.add((IFigure)this.rightFigure);
            this.add((IFigure)this.emptyLabel);
        } else {
            this.nameLabel.setLabelAlignment(1);
            this.parameterLabel.setLabelAlignment(4);
            this.nameLabel.setBorder((Border)new MarginBorder(0, 10, 0, 0));
            this.add((IFigure)this.emptyLabel);
            this.add((IFigure)this.leftFigure);
            this.add((IFigure)this.centerFigure);
            this.add((IFigure)this.rightFigure);
            this.add((IFigure)this.nameLabel);
            this.add((IFigure)this.parameterLabel);
        }
    }

    public Label getNameLabel() {
        return this.nameLabel;
    }

    public void setNameLabelText(String name) {
        this.nameLabel.setText(name != null ? name : "");
    }

    public Figure getCenterFigure() {
        return this.centerFigure;
    }

    public Label getParameterLabel() {
        return this.parameterLabel;
    }

    public void setParameterLabelText(String parameter) {
        if (parameter != null && !parameter.isEmpty()) {
            this.parameterLabel.setText("(" + parameter + ")");
            this.parameterLabel.setToolTip((IFigure)new Label(parameter));
        } else {
            this.parameterLabel.setText("");
        }
    }
}

