/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.scoping;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.fordiac.ide.model.data.DataPackage;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.structuredtextcore.scoping.AbstractSTCoreScopeProvider;
import org.eclipse.fordiac.ide.structuredtextcore.scoping.STStandardFunctionProvider;
import org.eclipse.fordiac.ide.structuredtextcore.scoping.STStandardFunctionScope;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCallArgument;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCorePackage;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STMemberAccessExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStructInitializerExpression;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.FilteringScope;
import org.eclipse.xtext.scoping.impl.IScopeWrapper;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.ImportScope;
import org.eclipse.xtext.scoping.impl.ScopeBasedSelectable;
import org.eclipse.xtext.scoping.impl.SelectableBasedScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;

public class STCoreScopeProvider
extends AbstractSTCoreScopeProvider {
    private static final List<IEObjectDescription> NON_USER_DEFINED_TYPES_DESCRIPTIONS = DataTypeLibrary.getNonUserDefinedDataTypes().stream().map(STCoreScopeProvider::descriptionForType).toList();
    private static final List<IEObjectDescription> LITERAL_TYPES_DESCRIPTIONS = Stream.concat(NON_USER_DEFINED_TYPES_DESCRIPTIONS.stream(), Stream.of(STCoreScopeProvider.descriptionForType("D", (DataType)IecTypes.ElementaryTypes.DATE), STCoreScopeProvider.descriptionForType("LD", (DataType)IecTypes.ElementaryTypes.LDATE), STCoreScopeProvider.descriptionForType("T", (DataType)IecTypes.ElementaryTypes.TIME), STCoreScopeProvider.descriptionForType("LT", (DataType)IecTypes.ElementaryTypes.LTIME))).toList();
    private static final Set<EReference> ANY_ELEMENTARY_LITERAL_REFERENCES = Set.of(STCorePackage.Literals.ST_NUMERIC_LITERAL__TYPE, STCorePackage.Literals.ST_DATE_LITERAL__TYPE, STCorePackage.Literals.ST_TIME_LITERAL__TYPE, STCorePackage.Literals.ST_TIME_OF_DAY_LITERAL__TYPE, STCorePackage.Literals.ST_DATE_AND_TIME_LITERAL__TYPE, STCorePackage.Literals.ST_STRING_LITERAL__TYPE);
    @Inject
    IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    STStandardFunctionProvider standardFunctionProvider;
    private IScopeWrapper scopeWrapper;

    public IScope getScope(EObject context, EReference reference) {
        if (reference == STCorePackage.Literals.ST_VAR_DECLARATION__TYPE) {
            IScope globalScope = super.getScope(context, reference);
            return STCoreScopeProvider.scopeForNonUserDefinedDataTypes(STCoreScopeProvider.filterScope(globalScope, (com.google.common.base.Predicate<IEObjectDescription>)((com.google.common.base.Predicate)this::isApplicableForVariableType)));
        }
        if (reference == STCorePackage.Literals.ST_TYPE_DECLARATION__TYPE) {
            IScope globalScope = super.getScope(context, reference);
            return STCoreScopeProvider.scopeForNonUserDefinedDataTypes(STCoreScopeProvider.filterScope(globalScope, (com.google.common.base.Predicate<IEObjectDescription>)((com.google.common.base.Predicate)this::isApplicableForTypeDeclaration)));
        }
        if (STCoreScopeProvider.isAnyElementaryLiteral(reference)) {
            return new SimpleScope(LITERAL_TYPES_DESCRIPTIONS, true);
        }
        if (reference == STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE) {
            STFeatureExpression expression;
            STExpression receiver = STCoreScopeProvider.getReceiver(context);
            if (receiver != null && receiver != context) {
                INamedElement receiverType = receiver.getResultType();
                if (receiverType != null) {
                    if (receiverType instanceof StructuredType) {
                        StructuredType structuredVarType = (StructuredType)receiverType;
                        return this.qualifiedScope((Iterable<? extends EObject>)structuredVarType.getMemberVariables(), reference);
                    }
                    if (receiverType instanceof FBType) {
                        FBType fbType = (FBType)receiverType;
                        InterfaceList interfaceList = fbType.getInterfaceList();
                        return this.qualifiedScope(Iterables.concat((Iterable)interfaceList.getInputVars(), (Iterable)interfaceList.getOutputVars(), (Iterable)interfaceList.getEventInputs()), reference);
                    }
                }
                return IScope.NULLSCOPE;
            }
            if (context instanceof STFeatureExpression && (expression = (STFeatureExpression)context).isCall()) {
                List<DataType> argumentTypes = expression.getParameters().stream().map(STCallArgument::getDeclaredResultType).map(DataType.class::cast).map(type -> (DataType)Objects.requireNonNullElse(type, IecTypes.GenericTypes.ANY)).toList();
                return new STStandardFunctionScope(STCoreScopeProvider.filterScope(super.getScope(context, reference), (com.google.common.base.Predicate<IEObjectDescription>)((com.google.common.base.Predicate)this::isApplicableForFeatureReference)), this.standardFunctionProvider, argumentTypes, true);
            }
            return new STStandardFunctionScope(STCoreScopeProvider.filterScope(super.getScope(context, reference), (com.google.common.base.Predicate<IEObjectDescription>)((com.google.common.base.Predicate)this::isApplicableForFeatureReference)), this.standardFunctionProvider, Collections.emptyList(), true);
        }
        if (reference == STCorePackage.Literals.ST_CALL_NAMED_INPUT_ARGUMENT__PARAMETER) {
            INamedElement feature = STCoreScopeProvider.getFeature(context);
            if (feature instanceof ICallable) {
                ICallable callable = (ICallable)feature;
                return this.qualifiedScope(Iterables.concat((Iterable)callable.getInputParameters(), (Iterable)callable.getInOutParameters()), reference);
            }
        } else if (reference == STCorePackage.Literals.ST_CALL_NAMED_OUTPUT_ARGUMENT__PARAMETER) {
            INamedElement feature = STCoreScopeProvider.getFeature(context);
            if (feature instanceof ICallable) {
                ICallable callable = (ICallable)feature;
                return this.qualifiedScope((Iterable<? extends EObject>)callable.getOutputParameters(), reference);
            }
        } else {
            if (reference == STCorePackage.Literals.ST_FOR_STATEMENT__VARIABLE) {
                return STCoreScopeProvider.filterScope(super.getScope(context, reference), (com.google.common.base.Predicate<IEObjectDescription>)((com.google.common.base.Predicate)this::isApplicableForVariableReference));
            }
            if (reference == STCorePackage.Literals.ST_STRUCT_INIT_ELEMENT__VARIABLE) {
                STStructInitializerExpression structInitializerExpression;
                INamedElement iNamedElement;
                EObject container = context.eContainer();
                if (container instanceof STStructInitializerExpression && (iNamedElement = (structInitializerExpression = (STStructInitializerExpression)container).getResultType()) instanceof StructuredType) {
                    StructuredType structType = (StructuredType)iNamedElement;
                    return this.qualifiedScope((Iterable<? extends EObject>)structType.getMemberVariables(), reference);
                }
            } else if (reference == STCorePackage.Literals.ST_ATTRIBUTE__DECLARATION) {
                return super.getScope(context, reference);
            }
        }
        return super.getScope(context, reference);
    }

    protected static IScope scopeForNonUserDefinedDataTypes(IScope parent) {
        return new SimpleScope(parent, NON_USER_DEFINED_TYPES_DESCRIPTIONS, true);
    }

    protected IScope qualifiedScope(Iterable<? extends EObject> elements, EReference reference) {
        return this.qualifiedScope(elements, reference, IScope.NULLSCOPE);
    }

    protected IScope qualifiedScope(Iterable<? extends EObject> elements, EReference reference, IScope parent) {
        Iterable descriptions = Scopes.scopedElementsFor(elements, (Function)this.qualifiedNameProvider);
        ScopeBasedSelectable importFrom = new ScopeBasedSelectable(this.wrap((IScope)new SimpleScope(descriptions, true)));
        List<ImportNormalizer> importNormalizers = STCoreScopeProvider.createImportNormalizers(descriptions);
        if (importNormalizers.isEmpty()) {
            return SelectableBasedScope.createScope((IScope)parent, (ISelectable)importFrom, (EClass)reference.getEReferenceType(), (boolean)true);
        }
        return new ImportScope(importNormalizers, parent, (ISelectable)importFrom, reference.getEReferenceType(), true);
    }

    protected static List<ImportNormalizer> createImportNormalizers(Iterable<IEObjectDescription> descriptions) {
        return StreamSupport.stream(descriptions.spliterator(), false).map(IEObjectDescription::getQualifiedName).map(name -> name.skipLast(1)).filter(Predicate.not(QualifiedName::isEmpty)).distinct().map(STCoreScopeProvider::createImportNormalizer).toList();
    }

    protected static ImportNormalizer createImportNormalizer(QualifiedName importedNamespace) {
        return new ImportNormalizer(importedNamespace, true, true);
    }

    protected static IScope filterScope(IScope scope, com.google.common.base.Predicate<IEObjectDescription> filter) {
        return new FilteringScope(scope, filter);
    }

    protected boolean isApplicableForVariableType(IEObjectDescription description) {
        EClass clazz = description.getEClass();
        return DataPackage.eINSTANCE.getDataType().isSuperTypeOf(clazz) || LibraryElementPackage.eINSTANCE.getFBType().isSuperTypeOf(clazz);
    }

    protected boolean isApplicableForTypeDeclaration(IEObjectDescription description) {
        EClass clazz = description.getEClass();
        return DataPackage.eINSTANCE.getDataType().isSuperTypeOf(clazz);
    }

    protected boolean isApplicableForVariableReference(IEObjectDescription description) {
        EClass clazz = description.getEClass();
        return STCorePackage.eINSTANCE.getSTVarDeclaration().isSuperTypeOf(clazz) || LibraryElementPackage.eINSTANCE.getVarDeclaration().isSuperTypeOf(clazz);
    }

    protected boolean isApplicableForFeatureReference(IEObjectDescription description) {
        EClass clazz = description.getEClass();
        return STCorePackage.eINSTANCE.getSTVarDeclaration().isSuperTypeOf(clazz) || LibraryElementPackage.eINSTANCE.getVarDeclaration().isSuperTypeOf(clazz) || LibraryElementPackage.eINSTANCE.getAdapterDeclaration().isSuperTypeOf(clazz) || LibraryElementPackage.eINSTANCE.getFB().isSuperTypeOf(clazz) || LibraryElementPackage.eINSTANCE.getICallable().isSuperTypeOf(clazz) && (!LibraryElementPackage.eINSTANCE.getFBType().isSuperTypeOf(clazz) || LibraryElementPackage.eINSTANCE.getFunctionFBType().isSuperTypeOf(clazz)) && !LibraryElementPackage.eINSTANCE.getEvent().isSuperTypeOf(clazz);
    }

    protected static boolean isAnyElementaryLiteral(EReference reference) {
        return ANY_ELEMENTARY_LITERAL_REFERENCES.contains(reference);
    }

    protected static STExpression getReceiver(EObject context) {
        if (context instanceof STFeatureExpression) {
            return STCoreScopeProvider.getReceiver(context.eContainer());
        }
        if (context instanceof STMemberAccessExpression) {
            STMemberAccessExpression memberAccessExpression = (STMemberAccessExpression)context;
            return memberAccessExpression.getReceiver();
        }
        return null;
    }

    protected static INamedElement getFeature(EObject context) {
        if (context instanceof STCallArgument) {
            return STCoreScopeProvider.getFeature(context.eContainer());
        }
        if (context instanceof STFeatureExpression) {
            STFeatureExpression featureExpression = (STFeatureExpression)context;
            return featureExpression.getFeature();
        }
        return null;
    }

    protected static IEObjectDescription descriptionForType(DataType type) {
        return new EObjectDescription(QualifiedName.create((String)type.getName()), (EObject)type, null);
    }

    protected static IEObjectDescription descriptionForType(String name, DataType type) {
        return new EObjectDescription(QualifiedName.create((String)name), (EObject)type, null);
    }

    public void setWrapper(IScopeWrapper wrapper) {
        super.setWrapper(wrapper);
        this.scopeWrapper = wrapper;
    }

    protected IScope wrap(IScope scope) {
        return this.scopeWrapper != null ? this.scopeWrapper.wrap(scope) : scope;
    }
}

