/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fortelauncher;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.fordiac.ide.debug.AbstractLaunchProcess;
import org.eclipse.fordiac.ide.fortelauncher.Messages;

public class StopForteLaunchDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String forteToStop = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", "");
        if (forteToStop.isBlank()) {
            throw new DebugException(Status.error((String)Messages.StopForte_NoForteExecutableGiven));
        }
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ArrayList<ILaunch> launchesToTerminate = new ArrayList<ILaunch>();
        ILaunch[] iLaunchArray = manager.getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch runningLaunch = iLaunchArray[n2];
            String location = runningLaunch.getLaunchConfiguration().getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", "");
            if (forteToStop.equals(location) && !runningLaunch.isTerminated()) {
                launchesToTerminate.add(runningLaunch);
            }
            ++n2;
        }
        StopForteProcess process = new StopForteProcess(configuration.getName(), launchesToTerminate, launch);
        process.start();
    }

    private static final class StopForteProcess
    extends AbstractLaunchProcess {
        private final Job job;
        private final List<ILaunch> launchesToTerminate;
        private boolean terminated;

        public StopForteProcess(String name, List<ILaunch> launchesToTerminate, ILaunch launch) {
            super(name, launch);
            this.launchesToTerminate = launchesToTerminate;
            this.job = Job.create((String)name, this::performStopFORTEs);
            this.job.addJobChangeListener(IJobChangeListener.onDone(this::terminated));
            this.job.setUser(true);
            launch.addProcess((IProcess)this);
            this.fireCreationEvent();
        }

        public void start() {
            this.job.schedule();
        }

        private IStatus performStopFORTEs(IProgressMonitor monitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.launchesToTerminate.size());
            for (ILaunch runningLaunch : this.launchesToTerminate) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (!runningLaunch.isTerminated()) {
                    try {
                        runningLaunch.terminate();
                    }
                    catch (DebugException e) {
                        return Status.error((String)MessageFormat.format(Messages.StopForteProcess_ExeceptionOccured, e.getMessage()), (Throwable)e);
                    }
                }
                subMonitor.worked(1);
            }
            return Status.OK_STATUS;
        }

        private void terminated(IJobChangeEvent event) {
            this.terminated = true;
            this.fireTerminateEvent();
        }

        public boolean canTerminate() {
            return !this.isTerminated();
        }

        public boolean isTerminated() {
            return this.terminated;
        }

        public void terminate() throws DebugException {
            this.job.cancel();
        }

        public IStreamsProxy getStreamsProxy() {
            return null;
        }

        public int getExitValue() throws DebugException {
            return 0;
        }
    }
}

