/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextManager;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class RunToLineAction
extends Action
implements IUpdate {
    private IWorkbenchPart fActivePart = null;
    private IRunToLineTarget fPartTarget = null;
    private final DebugContextListener fContextListener = new DebugContextListener();
    private ISuspendResume fTargetElement = null;
    private final IDocument fDocument;
    private final IVerticalRulerInfo fRulerInfo;

    public RunToLineAction(IWorkbenchPart part, IDocument document, IVerticalRulerInfo rulerInfo) {
        super(ActionMessages.RunToLineAction_2 + "\t" + DebugUIPlugin.formatKeyBindingString(SWT.MOD1 + SWT.MOD3, ActionMessages.RunToLineAction_3));
        this.fActivePart = part;
        this.fDocument = document;
        this.fRulerInfo = rulerInfo;
        this.initializeListeners();
    }

    public void run() {
        this.doIt();
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof MenuItem) {
            this.doIt();
        } else if ((event.stateMask & SWT.MOD1) > 0 && (event.stateMask & SWT.MOD3) > 0) {
            this.doIt();
        }
    }

    void doIt() {
        if (this.fPartTarget != null && this.fTargetElement != null) {
            try {
                int line;
                IDocument document = this.getDocument();
                if (document != null && (line = this.fRulerInfo.getLineOfLastMouseButtonActivity()) > -1) {
                    ITextSelection selection = this.getTextSelection(document, line);
                    this.fPartTarget.runToLine(this.fActivePart, (ISelection)selection, this.fTargetElement);
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.errorDialog(this.fActivePart.getSite().getWorkbenchWindow().getShell(), ActionMessages.RunToLineAction_0, ActionMessages.RunToLineAction_1, e.getStatus());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void dispose() {
        IDebugContextManager manager = DebugUITools.getDebugContextManager();
        if (this.fActivePart != null) {
            IWorkbenchWindow ww = this.fActivePart.getSite().getWorkbenchWindow();
            if (ww != null) {
                manager.getContextService(ww).removeDebugContextListener(this.fContextListener);
            } else {
                manager.removeDebugContextListener(this.fContextListener);
            }
        }
        this.fActivePart = null;
        this.fTargetElement = null;
        this.fPartTarget = null;
    }

    public void update() {
        Runnable r = () -> this.setEnabled(this.isTargetEnabled());
        DebugUIPlugin.getStandardDisplay().asyncExec(r);
    }

    private boolean isTargetEnabled() {
        ISelectionProvider selectionProvider;
        IWorkbenchPartSite site;
        boolean enabled = false;
        if (this.fPartTarget != null && this.fTargetElement != null && (site = this.fActivePart.getSite()) != null && (selectionProvider = site.getSelectionProvider()) != null) {
            ISelection selection = selectionProvider.getSelection();
            enabled = this.fTargetElement.isSuspended() && this.fPartTarget.canRunToLine(this.fActivePart, selection, this.fTargetElement);
        }
        return enabled;
    }

    private void initializeListeners() {
        IAdapterManager adapterManager;
        IDebugContextManager manager = DebugUITools.getDebugContextManager();
        IWorkbenchWindow workbenchWindow = this.fActivePart.getSite().getWorkbenchWindow();
        IDebugContextService service = manager.getContextService(workbenchWindow);
        service.addDebugContextListener(this.fContextListener);
        this.fPartTarget = (IRunToLineTarget)this.fActivePart.getAdapter(IRunToLineTarget.class);
        if (this.fPartTarget == null && (adapterManager = Platform.getAdapterManager()).hasAdapter((Object)this.fActivePart, IRunToLineTarget.class.getName())) {
            this.fPartTarget = (IRunToLineTarget)adapterManager.loadAdapter((Object)this.fActivePart, IRunToLineTarget.class.getName());
        }
        ISelection activeContext = service.getActiveContext();
        this.fContextListener.contextActivated(activeContext);
    }

    private IDocument getDocument() {
        ITextEditor editor;
        IDocumentProvider provider;
        if (this.fDocument != null) {
            return this.fDocument;
        }
        if (this.fActivePart instanceof ITextEditor && (provider = (editor = (ITextEditor)this.fActivePart).getDocumentProvider()) != null) {
            return provider.getDocument((Object)editor.getEditorInput());
        }
        IDocument doc = (IDocument)this.fActivePart.getAdapter(IDocument.class);
        if (doc != null) {
            return doc;
        }
        return null;
    }

    private ITextSelection getTextSelection(IDocument document, int line) throws BadLocationException {
        ISelection selection;
        IRegion region = document.getLineInformation(line);
        TextSelection textSelection = new TextSelection(document, region.getOffset(), 0);
        ISelectionProvider provider = this.fActivePart.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof ITextSelection && ((ITextSelection)selection).getStartLine() <= line && ((ITextSelection)selection).getEndLine() >= line) {
            textSelection = (ITextSelection)selection;
        }
        return textSelection;
    }

    class DebugContextListener
    implements IDebugContextListener {
        DebugContextListener() {
        }

        protected void contextActivated(ISelection selection) {
            IStructuredSelection ss;
            RunToLineAction.this.fTargetElement = null;
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
                RunToLineAction.this.fTargetElement = (ISuspendResume)DebugPlugin.getAdapter((Object)ss.getFirstElement(), ISuspendResume.class);
            }
            RunToLineAction.this.update();
        }

        @Override
        public void debugContextChanged(DebugContextEvent event) {
            this.contextActivated(event.getContext());
        }
    }
}

