/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.errormessages;

public class ErrorMessage {
    private static final int DEFAULT_DISABLE_AFTER_MS = 3000;
    private final String message;
    private final int timeout;
    private long enableTime = System.currentTimeMillis();
    private boolean valid = true;

    ErrorMessage(String message, int timeout) {
        this.message = message;
        this.timeout = timeout > 0 ? timeout : 3000;
    }

    public void setInvalid() {
        this.valid = false;
    }

    public boolean isStillValid() {
        return this.valid && System.currentTimeMillis() - this.enableTime < (long)this.timeout;
    }

    public String getMessage() {
        return this.message;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void updateEnabled() {
        this.enableTime = System.currentTimeMillis();
    }

    public int hashCode() {
        return this.message.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorMessage other = (ErrorMessage)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        this.updateEnabled();
        ((ErrorMessage)obj).updateEnabled();
        return true;
    }
}

