/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.types.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.types.OrderedSetType;
import org.eclipse.ocl.types.operations.CollectionTypeOperations;
import org.eclipse.ocl.util.OCLUtil;

public class OrderedSetTypeOperations
extends CollectionTypeOperations {
    protected OrderedSetTypeOperations() {
    }

    public static <C, O> boolean checkCollectionTypeName(OrderedSetType<C, O> orderedSetType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Environment env = OCLUtil.getValidationEnvironment(orderedSetType, context);
        if (env != null) {
            String name = orderedSetType.getName();
            Object elementType = orderedSetType.getElementType();
            if (elementType != null) {
                String elementTypeName = env.getUMLReflection().getName(elementType);
                result = ("OrderedSet(" + elementTypeName + ")").equals(name);
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.types", 7, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"checkCollectionTypeName", EObjectValidator.getObjectLabel(orderedSetType, context)}), new Object[]{orderedSetType}));
        }
        return result;
    }
}

