/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.attributetypeeditor.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.attributetypeeditor.editors.AttributeTypeEditor;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeTargetAttributeCommand;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AttributeTargetSection
extends AbstractSection {
    private final List<Button> buttons = new ArrayList<Button>();
    private StructuredType target;
    private final SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            Button btn = (Button)event.getSource();
            AttributeTargetSection.this.target.getMemberVariables().stream().filter(member -> member.getName().equals(btn.getText())).findFirst().ifPresent(correctMember -> {
                Value val = correctMember.getValue();
                val.setValue(Boolean.toString(btn.getSelection()).toUpperCase());
                AttributeTargetSection.this.executeCommand((Command)new ChangeTargetAttributeCommand(AttributeTargetSection.this.getType(), AttributeTargetSection.this.target));
                AttributeTargetSection.this.refresh();
            });
        }
    };

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createCheckBoxes(parent);
    }

    public void createCheckBoxes(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        ((StructuredType)InternalAttributeDeclarations.TARGET.getType()).getMemberVariables().forEach(member -> this.createButton(composite, member.getName()));
    }

    private void createButton(Composite parent, String buttonName) {
        Button button = new Button(parent, 32);
        button.setBackground(parent.getBackground());
        button.setText(buttonName);
        button.addSelectionListener(this.buttonListener);
        this.buttons.add(button);
    }

    public void performRefresh() {
        this.updateButtons(this.getType());
    }

    private void updateButtons(AttributeDeclaration attributeDeclaration) {
        StructuredType targetStruct = AttributeTargetSection.getTarget(attributeDeclaration);
        targetStruct.getMemberVariables().forEach(member -> {
            for (Button button : this.buttons) {
                if (!member.getName().equals(button.getText())) continue;
                button.setSelection(Boolean.parseBoolean(member.getValue().getValue()));
            }
        });
    }

    private static StructuredType getTarget(AttributeDeclaration attributeDeclaration) {
        StructuredType targetStruct = attributeDeclaration.getTarget();
        if (targetStruct == null) {
            return (StructuredType)EcoreUtil.copy((EObject)InternalAttributeDeclarations.TARGET.getType());
        }
        return targetStruct;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (part instanceof AttributeTypeEditor) {
            AttributeTypeEditor editor = (AttributeTypeEditor)part;
            this.setType(editor.getAdapter(LibraryElement.class));
            this.target = AttributeTargetSection.getTarget(this.getType());
        }
    }

    protected AttributeDeclaration getType() {
        AttributeDeclaration decl;
        Object object = this.type;
        return object instanceof AttributeDeclaration ? (decl = (AttributeDeclaration)object) : null;
    }

    protected Object getInputType(Object input) {
        if (input instanceof AttributeDeclaration) {
            AttributeDeclaration attDecl = (AttributeDeclaration)input;
            this.updateButtons(attDecl);
            this.target = AttributeTargetSection.getTarget(attDecl);
            return attDecl;
        }
        return null;
    }

    protected void setInputCode() {
    }

    protected void setInputInit() {
    }
}

