/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.NotificationMessage;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class RepublishResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=833");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=835");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=834");
    private final ResponseHeader responseHeader;
    private final NotificationMessage notificationMessage;

    public RepublishResponse(ResponseHeader responseHeader, NotificationMessage notificationMessage) {
        this.responseHeader = responseHeader;
        this.notificationMessage = notificationMessage;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public NotificationMessage getNotificationMessage() {
        return this.notificationMessage;
    }

    protected RepublishResponse(RepublishResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((RepublishResponseBuilder)b).responseHeader;
        this.notificationMessage = ((RepublishResponseBuilder)b).notificationMessage;
    }

    public static RepublishResponseBuilder<?, ?> builder() {
        return new RepublishResponseBuilderImpl();
    }

    public RepublishResponseBuilder<?, ?> toBuilder() {
        return new RepublishResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepublishResponse)) {
            return false;
        }
        RepublishResponse other = (RepublishResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        NotificationMessage this$notificationMessage = this.getNotificationMessage();
        NotificationMessage other$notificationMessage = other.getNotificationMessage();
        return !(this$notificationMessage == null ? other$notificationMessage != null : !((Object)this$notificationMessage).equals(other$notificationMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RepublishResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        NotificationMessage $notificationMessage = this.getNotificationMessage();
        result = result * 59 + ($notificationMessage == null ? 43 : ((Object)$notificationMessage).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RepublishResponse(responseHeader=" + this.getResponseHeader() + ", notificationMessage=" + this.getNotificationMessage() + ")";
    }

    private static final class RepublishResponseBuilderImpl
    extends RepublishResponseBuilder<RepublishResponse, RepublishResponseBuilderImpl> {
        private RepublishResponseBuilderImpl() {
        }

        @Override
        protected RepublishResponseBuilderImpl self() {
            return this;
        }

        @Override
        public RepublishResponse build() {
            return new RepublishResponse(this);
        }
    }

    public static abstract class RepublishResponseBuilder<C extends RepublishResponse, B extends RepublishResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private NotificationMessage notificationMessage;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RepublishResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(RepublishResponse instance, RepublishResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.notificationMessage(instance.notificationMessage);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B notificationMessage(NotificationMessage notificationMessage) {
            this.notificationMessage = notificationMessage;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "RepublishResponse.RepublishResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", notificationMessage=" + this.notificationMessage + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<RepublishResponse> {
        @Override
        public Class<RepublishResponse> getType() {
            return RepublishResponse.class;
        }

        @Override
        public RepublishResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            NotificationMessage notificationMessage = (NotificationMessage)decoder.readStruct("NotificationMessage", NotificationMessage.TYPE_ID);
            return new RepublishResponse(responseHeader, notificationMessage);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, RepublishResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeStruct("NotificationMessage", (Object)value.getNotificationMessage(), NotificationMessage.TYPE_ID);
        }
    }
}

