/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.fordiac.ide.application.commands.CreateSubAppCrossingConnectionsCommand;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteInterfaceCommand;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.validation.LinkConstraints;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class BorderCrossingReconnectCommand
extends CompoundCommand {
    final IInterfaceElement source;
    final IInterfaceElement target;
    final Connection connection;
    final boolean isSourceReconnect;
    final Set<IInterfaceElement> affectedPins = new HashSet<IInterfaceElement>();

    public BorderCrossingReconnectCommand(IInterfaceElement source, IInterfaceElement target, Connection connection, boolean isSourceReconnect) {
        this.source = source;
        this.target = target;
        this.connection = connection;
        this.isSourceReconnect = isSourceReconnect;
        this.init();
    }

    public void execute() {
        super.execute();
        this.affectedPins.stream().filter(BorderCrossingReconnectCommand::hasNoConnections).forEach(inOutPin -> {
            DeleteInterfaceCommand cmd = new DeleteInterfaceCommand(inOutPin);
            cmd.execute();
            this.add((Command)cmd);
        });
    }

    private static boolean hasNoConnections(IInterfaceElement pin) {
        VarDeclaration varDecl;
        if (pin instanceof VarDeclaration && (varDecl = (VarDeclaration)pin).isInOutVar()) {
            return BorderCrossingReconnectCommand.inOutHasNoConnections(varDecl);
        }
        return pin.getInputConnections().isEmpty() && pin.getOutputConnections().isEmpty();
    }

    private static boolean inOutHasNoConnections(VarDeclaration inOutPin) {
        VarDeclaration opposite = inOutPin.getInOutVarOpposite();
        return inOutPin.getInputConnections().isEmpty() && inOutPin.getOutputConnections().isEmpty() && opposite.getInputConnections().isEmpty() && opposite.getOutputConnections().isEmpty();
    }

    private void init() {
        if (this.isSourceReconnect) {
            ArrayList<IInterfaceElement> sinks = new ArrayList<IInterfaceElement>();
            this.collectSinksRec(this.connection, sinks);
            for (IInterfaceElement sink : sinks) {
                this.add(CreateSubAppCrossingConnectionsCommand.createProcessBorderCrossingConnection(this.source, sink));
            }
        } else {
            ArrayList<IInterfaceElement> sources = new ArrayList<IInterfaceElement>();
            this.collectSourcesRec(this.connection, sources, true);
            for (IInterfaceElement src : sources) {
                this.add(CreateSubAppCrossingConnectionsCommand.createProcessBorderCrossingConnection(src, this.target));
            }
        }
    }

    private void collectSinksRec(Connection conn, List<IInterfaceElement> sinks) {
        this.add((Command)new DeleteConnectionCommand(conn));
        if (!conn.getDestination().getOutputConnections().isEmpty()) {
            IInterfaceElement destination = conn.getDestination();
            for (Connection outConn : destination.getOutputConnections()) {
                this.collectSinksRec(outConn, sinks);
            }
            this.addPin(destination);
        } else {
            sinks.add(conn.getDestination());
        }
    }

    private void addPin(IInterfaceElement pin) {
        VarDeclaration varDecl;
        if (pin instanceof VarDeclaration && (varDecl = (VarDeclaration)pin).isInOutVar()) {
            this.affectedPins.add((IInterfaceElement)(varDecl.isIsInput() ? varDecl : varDecl.getInOutVarOpposite()));
        } else {
            this.affectedPins.add(pin);
        }
    }

    private void collectSourcesRec(Connection conn, List<IInterfaceElement> sources, boolean deleteCon) {
        IInterfaceElement src = conn.getSource();
        if (deleteCon) {
            this.add((Command)new DeleteConnectionCommand(conn));
            boolean bl = deleteCon = src.getOutputConnections().size() == 1;
        }
        if (!src.getInputConnections().isEmpty()) {
            for (Connection outConn : src.getInputConnections()) {
                this.collectSourcesRec(outConn, sources, deleteCon);
            }
            this.addPin(src);
        } else {
            sources.add(src);
        }
    }

    private static boolean isEpxandedSubapp(IInterfaceElement ie) {
        SubApp subapp;
        FBNetworkElement fBNetworkElement = ie.getFBNetworkElement();
        return fBNetworkElement instanceof SubApp && (subapp = (SubApp)fBNetworkElement).isUnfolded();
    }

    public boolean canExecute() {
        if (!this.source.getClass().isAssignableFrom(this.target.getClass()) && !this.target.getClass().isAssignableFrom(this.source.getClass())) {
            ErrorMessenger.popUpErrorMessage((String)Messages.LinkConstraints_ConnectingIncompatibleInterfaceTypes);
            return false;
        }
        if (this.isSourceReconnect) {
            if (!BorderCrossingReconnectCommand.isEpxandedSubapp(this.source) && this.source.isIsInput()) {
                ErrorMessenger.popUpErrorMessage((String)Messages.LinkConstraints_STATUSMessage_IN_IN_OUT_OUT_notAllowed);
                return false;
            }
        } else if (!BorderCrossingReconnectCommand.isEpxandedSubapp(this.target) && !this.target.isIsInput()) {
            ErrorMessenger.popUpErrorMessage((String)Messages.LinkConstraints_STATUSMessage_IN_IN_OUT_OUT_notAllowed);
            return false;
        }
        if (this.source instanceof Event) {
            return true;
        }
        if (this.source instanceof VarDeclaration) {
            return this.canExecuteDataCon();
        }
        if (this.source instanceof AdapterDeclaration) {
            return this.canExecuteAdapterCon();
        }
        return false;
    }

    private boolean canExecuteDataCon() {
        if (!this.isSourceReconnect) {
            return super.canExecute();
        }
        if (!(this.source.getType() instanceof StructuredType && this.target.getType() instanceof StructuredType || LinkConstraints.typeCheck((IInterfaceElement)this.source, (IInterfaceElement)this.target))) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_STATUSMessage_NotCompatible, this.source.getType() != null ? this.source.getType().getName() : FordiacMessages.NA, this.target.getType() != null ? this.target.getType().getName() : FordiacMessages.NA));
            return false;
        }
        return LinkConstraints.isWithConstraintOK((IInterfaceElement)this.source) && LinkConstraints.isWithConstraintOK((IInterfaceElement)this.target);
    }

    private boolean canExecuteAdapterCon() {
        if (this.isSourceReconnect) {
            if (!this.source.getOutputConnections().isEmpty()) {
                ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_STATUSMessage_hasAlreadyOutputConnection, this.source.getName()));
                return false;
            }
        } else if (!this.target.getInputConnections().isEmpty()) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_STATUSMessage_hasAlreadyInputConnection, this.target.getName()));
            return false;
        }
        if (!LinkConstraints.adapaterTypeCompatibilityCheck((IInterfaceElement)this.source, (IInterfaceElement)this.target)) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_STATUSMessage_NotCompatible, this.source.getType() != null ? this.source.getType().getName() : FordiacMessages.ND, this.target.getType() != null ? this.target.getType().getName() : FordiacMessages.ND));
            return false;
        }
        return true;
    }
}

