/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.policies;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.application.editparts.ConnectionEditPart;
import org.eclipse.fordiac.ide.application.figures.FBNetworkConnection;
import org.eclipse.fordiac.ide.application.figures.FBNetworkConnectionLabel;
import org.eclipse.fordiac.ide.application.handles.FBNConnectionEndPointHandle;
import org.eclipse.fordiac.ide.application.handles.HiddenFBNConnectionEndPointHandle;
import org.eclipse.fordiac.ide.gef.policies.FeedbackConnectionEndpointEditPolicy;
import org.eclipse.fordiac.ide.gef.policies.ModifiedMoveHandle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.handles.ConnectionEndpointHandle;

public class FBNConnectionEndpointPolicy
extends FeedbackConnectionEndpointEditPolicy {
    protected ConnectionEndpointHandle createConnectionEndPointHandle(org.eclipse.gef.ConnectionEditPart connectionEditPart, int connectionLocator) {
        FBNetworkConnection con = (FBNetworkConnection)connectionEditPart.getFigure();
        if (!con.isHidden() || connectionLocator == 2 && con.getSourceDecoration() == null || connectionLocator == 3 && con.getTargetDecoration() == null) {
            return new FBNConnectionEndPointHandle(connectionEditPart, connectionLocator);
        }
        return new HiddenFBNConnectionEndPointHandle(connectionEditPart, connectionLocator);
    }

    protected IFigure createSelectionFeedbackFigure(PolylineConnection connFigure) {
        FBNetworkConnection con = (FBNetworkConnection)connFigure;
        if (!con.isHidden()) {
            return super.createSelectionFeedbackFigure(connFigure);
        }
        return FBNConnectionEndpointPolicy.createHiddenConnectionSelectionFeedbackFigure(con);
    }

    public ConnectionEditPart getHost() {
        return (ConnectionEditPart)super.getHost();
    }

    public void showSelection() {
        super.showSelection();
        this.setAssociatedConnectionsWidth(5);
    }

    public void hideSelection() {
        super.hideSelection();
        this.setAssociatedConnectionsWidth(2);
    }

    private void setAssociatedConnectionsWidth(int width) {
        EditPart destination;
        EditPart source = this.getHost().getSource();
        if (source instanceof AbstractGraphicalEditPart) {
            AbstractGraphicalEditPart sourceEP = (AbstractGraphicalEditPart)source;
            this.setConnectionsWidth(sourceEP.getSourceConnections(), width);
        }
        if ((destination = this.getHost().getTarget()) instanceof AbstractGraphicalEditPart) {
            AbstractGraphicalEditPart destEP = (AbstractGraphicalEditPart)destination;
            this.setConnectionsWidth(destEP.getTargetConnections(), width);
        }
    }

    private void setConnectionsWidth(List<? extends org.eclipse.gef.ConnectionEditPart> list, int width) {
        list.stream().filter(ConnectionEditPart.class::isInstance).map(ConnectionEditPart.class::cast).forEach(ep -> this.setConnectionWidth((ConnectionEditPart)((Object)ep), width));
    }

    private void setConnectionWidth(ConnectionEditPart ep, int width) {
        if (ep != this.getHost() && !ep.isSelectionShown()) {
            ep.getConnectionFigure().setLineWidth(width);
        }
    }

    private static Figure createHiddenConnectionSelectionFeedbackFigure(FBNetworkConnection con) {
        Figure figure = new Figure(){

            public Rectangle getBounds() {
                if (this.bounds == null) {
                    this.bounds = new Rectangle();
                    this.getChildren().forEach(el -> {
                        Rectangle rectangle = this.bounds.union(el.getBounds());
                    });
                }
                return this.bounds;
            }

            public void layout() {
                this.bounds = null;
                this.getBounds();
                this.fireFigureMoved();
            }
        };
        figure.setLayoutManager((LayoutManager)new StackLayout());
        if (con.getSourceDecoration() != null) {
            figure.add(FBNConnectionEndpointPolicy.selectonOverlayFigure(con.getSourceDecoration()));
            figure.add(FBNConnectionEndpointPolicy.createHidenSelectionFeedbackEndpoint(con.getSourceDecoration()));
        }
        if (con.getTargetDecoration() != null) {
            figure.add(FBNConnectionEndpointPolicy.selectonOverlayFigure(con.getTargetDecoration()));
            figure.add(FBNConnectionEndpointPolicy.createHidenSelectionFeedbackEndpoint(con.getTargetDecoration()));
        }
        return figure;
    }

    private static IFigure selectonOverlayFigure(FBNetworkConnectionLabel label) {
        Figure fig = new Figure();
        Rectangle bounds = FBNConnectionEndpointPolicy.getSelectableFigureBounds((IFigure)label);
        fig.setBounds(bounds);
        fig.setBackgroundColor(ColorConstants.white);
        fig.setOpaque(true);
        Label lab = new Label(label.getLabel().getText());
        lab.setBackgroundColor(ColorConstants.white);
        lab.setForegroundColor(label.getForegroundColor());
        lab.setBounds(bounds);
        lab.setBorder((Border)new LineBorder(label.getForegroundColor(), 2));
        lab.setOpaque(true);
        fig.add((IFigure)lab);
        return fig;
    }

    private static IFigure createHidenSelectionFeedbackEndpoint(FBNetworkConnectionLabel label) {
        RoundedRectangle newSelFeedbackFigure = new RoundedRectangle();
        newSelFeedbackFigure.setAlpha(50);
        newSelFeedbackFigure.setOutline(false);
        newSelFeedbackFigure.setBounds(FBNConnectionEndpointPolicy.getSelectableFigureBounds((IFigure)label));
        newSelFeedbackFigure.setCornerDimensions(new Dimension(6, 6));
        newSelFeedbackFigure.setForegroundColor(ModifiedMoveHandle.getSelectionColor());
        newSelFeedbackFigure.setBackgroundColor(ModifiedMoveHandle.getSelectionColor());
        return newSelFeedbackFigure;
    }

    private static Rectangle getSelectableFigureBounds(IFigure figure) {
        return figure.getBounds().getExpanded(2, 2);
    }
}

