/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug;

import java.text.MessageFormat;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugVariable;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugDevice;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugElement;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugThread;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugVariable;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentProcess;
import org.eclipse.fordiac.ide.deployment.debug.IDeploymentDebugTarget;
import org.eclipse.fordiac.ide.deployment.debug.Messages;
import org.eclipse.fordiac.ide.deployment.debug.breakpoint.DeploymentWatchpoint;
import org.eclipse.fordiac.ide.deployment.debug.watch.IWatch;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public class DeploymentDebugTarget
extends DeploymentDebugElement
implements IDeploymentDebugTarget {
    private final ILaunch launch;
    private final AutomationSystem system;
    private final boolean allowTerminate;
    private final Duration pollingInterval;
    private final DeploymentProcess process;
    private final DeploymentDebugThread thread;
    private final AtomicLong variableUpdateCount = new AtomicLong();
    private final Map<String, IWatch> watches = new ConcurrentSkipListMap<String, IWatch>();
    private boolean terminated;
    private boolean disconnected;

    public DeploymentDebugTarget(AutomationSystem system, Set<INamedElement> selection, ILaunch launch, boolean allowTerminate, Duration pollingInterval) throws DeploymentException {
        super(null);
        this.launch = launch;
        this.system = system;
        this.allowTerminate = allowTerminate;
        this.pollingInterval = pollingInterval;
        this.process = new DeploymentProcess(system, selection, launch);
        this.process.getJob().addJobChangeListener(IJobChangeListener.onDone(this::deploymentDone));
        this.thread = new DeploymentDebugThread(this);
        launch.addDebugTarget((IDebugTarget)this);
        this.fireCreationEvent();
    }

    private void deploymentDone(IJobChangeEvent event) {
        if (event.getResult().isOK()) {
            Job.create((String)MessageFormat.format(Messages.DeploymentDebugTarget_ConnectJobName, this.getName()), this::doConnect).schedule();
        } else {
            this.terminated();
        }
    }

    protected void doConnect(IProgressMonitor monitor) throws CoreException {
        EList devices = this.system.getSystemConfiguration().getDevices();
        monitor.beginTask(MessageFormat.format(Messages.DeploymentDebugTarget_ConnectJobName, this.getName()), devices.size());
        ConnectJobGroup group = new ConnectJobGroup(this.getName(), devices.size());
        for (Device device : devices) {
            Job job = Job.create((String)MessageFormat.format(Messages.DeploymentDebugTarget_ConnectJobName, device.getName()), unused -> this.doConnect(device));
            job.setProgressGroup(monitor, 1);
            job.setJobGroup((JobGroup)group);
            job.schedule();
        }
        try {
            group.join(0L, monitor);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CoreException(Status.error((String)e.getLocalizedMessage(), (Throwable)e));
        }
        if (group.getResult().isOK()) {
            this.thread.fireSuspendEvent(32);
        } else if (group.getResult().getChildren().length < devices.size()) {
            this.fireChangeEvent(256);
            this.thread.fireSuspendEvent(32);
        } else {
            this.terminated();
        }
    }

    protected void doConnect(Device device) throws DebugException {
        DeploymentDebugDevice deploymentDevice = new DeploymentDebugDevice(device, this, this.allowTerminate, this.pollingInterval);
        try {
            deploymentDevice.connect();
        }
        catch (DebugException e) {
            deploymentDevice.disconnect();
            throw e;
        }
    }

    public void start() {
        this.process.start();
    }

    public long getVariableUpdateCount() {
        return this.variableUpdateCount.get();
    }

    public long incrementVariableUpdateCount() {
        return this.variableUpdateCount.incrementAndGet();
    }

    public TypeLibrary getTypeLibrary() {
        return this.system.getTypeLibrary();
    }

    public EvaluatorDebugVariable createVariable(Variable<?> variable, String expression) {
        return new DeploymentDebugVariable(variable, expression, this);
    }

    @Override
    public Map<String, IWatch> getWatches() {
        return Collections.unmodifiableMap(this.watches);
    }

    public boolean canResume() {
        return false;
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean isSuspended() {
        return false;
    }

    public void resume() throws DebugException {
        throw DeploymentDebugTarget.createUnsupportedOperationException();
    }

    public void suspend() throws DebugException {
        throw DeploymentDebugTarget.createUnsupportedOperationException();
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        DeploymentWatchpoint watchpoint;
        return breakpoint instanceof DeploymentWatchpoint && (watchpoint = (DeploymentWatchpoint)breakpoint).isRelevant(this.getSystem());
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.updateWatches(true);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.updateWatches(true);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.updateWatches(false);
    }

    public void updateWatches(boolean structureChanged) {
        if (structureChanged) {
            Map<String, IWatch> combinedWatches = Stream.of(this.launch.getDebugTargets()).filter(DeploymentDebugDevice.class::isInstance).map(DeploymentDebugDevice.class::cast).map(DeploymentDebugDevice::getWatches).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.watches.keySet().retainAll(combinedWatches.keySet());
            this.watches.putAll(combinedWatches);
        }
        if (this.hasThreads()) {
            this.thread.getTopStackFrame().fireChangeEvent(512);
        }
    }

    @Override
    public String getName() {
        return this.system.getName();
    }

    @Override
    public IDeploymentDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    @Override
    public AutomationSystem getSystem() {
        return this.system;
    }

    public Duration getPollingInterval() {
        return this.pollingInterval;
    }

    public boolean isAllowTerminate() {
        return this.allowTerminate;
    }

    public boolean canTerminate() {
        return !this.isTerminated() && !this.isDisconnected() && this.allowTerminate;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void terminate() throws DebugException {
        this.terminated();
        this.launch.terminate();
    }

    protected void terminated() {
        this.terminated = true;
        this.fireTerminateEvent();
    }

    public boolean canDisconnect() {
        return !this.isTerminated() && !this.isDisconnected();
    }

    public void disconnect() throws DebugException {
        this.disconnected();
        ILaunch iLaunch = this.launch;
        if (iLaunch instanceof IDisconnect) {
            IDisconnect disconnect = (IDisconnect)iLaunch;
            disconnect.disconnect();
        }
    }

    protected void disconnected() {
        this.disconnected = true;
        this.fireTerminateEvent();
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        throw DeploymentDebugTarget.createUnsupportedOperationException();
    }

    public DeploymentProcess getProcess() {
        return this.process;
    }

    public IThread[] getThreads() {
        IThread[] iThreadArray;
        if (this.hasThreads()) {
            IThread[] iThreadArray2 = new IThread[1];
            iThreadArray = iThreadArray2;
            iThreadArray2[0] = this.thread;
        } else {
            iThreadArray = new IThread[]{};
        }
        return iThreadArray;
    }

    public boolean hasThreads() {
        return this.process.isTerminated() && !this.isTerminated() && !this.isDisconnected();
    }

    protected static class ConnectJobGroup
    extends JobGroup {
        private final int devices;

        public ConnectJobGroup(String name, int devices) {
            super(MessageFormat.format(Messages.DeploymentDebugTarget_ConnectJobName, name), 0, devices);
            this.devices = devices;
        }

        protected boolean shouldCancel(IStatus lastCompletedJobResult, int numberOfFailedJobs, int numberOfCanceledJobs) {
            return numberOfFailedJobs + numberOfCanceledJobs >= this.devices;
        }
    }
}

