/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typeeditor.internal;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.typeeditor.ITypeEditorPage;
import org.eclipse.fordiac.ide.typeeditor.internal.TypeEditorPageDescriptor;

public class TypeEditorPageFactory {
    private static final String TYPE_EDITOR_PAGE_EXTENSION_POINT_ID = "org.eclipse.fordiac.ide.typeeditor.typeEditorPage";
    private final List<TypeEditorPageDescriptor> editorPages = TypeEditorPageFactory.loadEditorPages();

    public Collection<ITypeEditorPage> getEditors(LibraryElement type) {
        return this.editorPages.stream().filter(ep -> ep.handlesType(type)).sorted(Comparator.comparingInt(TypeEditorPageDescriptor::getSortIndex)).map(TypeEditorPageDescriptor::createEditorPage).filter(Objects::nonNull).toList();
    }

    private static List<TypeEditorPageDescriptor> loadEditorPages() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(TYPE_EDITOR_PAGE_EXTENSION_POINT_ID);
        return Stream.of(point.getExtensions()).map(IExtension::getConfigurationElements).flatMap(iConfigurationElementArray -> Stream.of(iConfigurationElementArray)).map(TypeEditorPageDescriptor::new).toList();
    }
}

