/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.resource;

import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.ArraySize;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.resource.FordiacTypeResource;
import org.eclipse.fordiac.ide.model.resource.TypeImportDiagnostic;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.structuredtextcore.Messages;
import org.eclipse.fordiac.ide.structuredtextcore.resource.LibraryElementXtextResource;
import org.eclipse.fordiac.ide.structuredtextcore.services.STCoreGrammarAccess;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STResource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.STCoreUtil;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCorePartition;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCorePartitioner;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCoreReconciler;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.LazyStringInputStream;
import org.eclipse.xtext.util.Tuples;

public class STCoreResource
extends LibraryElementXtextResource
implements STResource {
    public static final String OPTION_PLAIN_ST = STCoreResource.class.getName() + ".PLAIN_ST";
    private static final String EXPECTED_TYPE_CACHE_KEY = "EXPECTED_TYPE";
    @Inject
    private FileExtensionProvider fileExtensionProvider;
    @Inject
    private STCorePartitioner partitioner;
    @Inject
    private STCoreReconciler reconciler;
    @Inject
    private STCoreGrammarAccess grammarAccess;
    private INamedElement expectedType;

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        Map<Object, Object> actualOptions = Objects.requireNonNullElse(options, this.getDefaultLoadOptions());
        if (this.isLoadPlainST(actualOptions, inputStream)) {
            this.setExpectedType((INamedElement)actualOptions.get(OPTION_EXPECTED_TYPE));
            super.doLoad(inputStream, actualOptions);
            if (this.getLibraryElement() == null) {
                TypeEntry typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForURI(this.uri);
                if (typeEntry != null) {
                    this.setLibraryElement(typeEntry.getType());
                }
            } else {
                this.updateInternalLibraryElement();
            }
        } else {
            LibraryElement libraryElement = this.loadLibraryElement(inputStream);
            if (libraryElement == null) {
                return;
            }
            String text = this.getSource(libraryElement);
            super.doLoad((InputStream)new LazyStringInputStream(text, this.getEncoding()), actualOptions);
            this.addInternalLibraryElement(libraryElement);
        }
    }

    protected LibraryElement loadLibraryElement(InputStream inputStream) {
        try {
            FordiacTypeResource typeResource;
            if (this.uri.hasQuery() && this.resourceSet != null) {
                typeResource = this.resourceSet.getResource(this.uri.trimQuery(), true);
            } else {
                typeResource = new FordiacTypeResource(this.uri);
                typeResource.load(inputStream, Collections.emptyMap());
            }
            this.getErrors().addAll((Collection)typeResource.getErrors());
            this.getWarnings().addAll((Collection)typeResource.getWarnings());
            return STCoreResource.findInternalLibraryElement((Resource)typeResource);
        }
        catch (Exception e) {
            this.handleTypeLoadException(e);
            return null;
        }
    }

    protected void addInternalLibraryElement(LibraryElement libraryElement) {
        if (this.contents != null && !this.contents.isEmpty()) {
            if (libraryElement.eResource().getResourceSet() != null) {
                this.contents.add((Object)STCoreResource.copyLibraryElement(libraryElement, !this.isIncludeInternalLibraryElement()));
            } else {
                this.contents.add((Object)libraryElement);
            }
            this.contents.addAll(EcoreUtil.copyAll(this.getAdditionalContent()));
            this.relink();
        }
    }

    protected String getSource(LibraryElement libraryElement) throws IOException {
        if (this.uri.hasQuery()) {
            Value value;
            EObject eObject;
            ArraySize arraySize;
            EObject eObject2;
            EObject sourceElement = this.getSourceElement(libraryElement);
            this.setIncludeInternalLibraryElement(this.needsInternalLibraryElement(libraryElement, sourceElement));
            if (sourceElement instanceof Attribute) {
                Attribute attribute = (Attribute)sourceElement;
                this.setEntryPoint(this.grammarAccess.getSTInitializerExpressionSourceRule());
                this.setExpectedType(STCoreUtil.getFeatureType((INamedElement)attribute));
                return Objects.requireNonNullElse(attribute.getValue(), "");
            }
            if (sourceElement instanceof ArraySize && (eObject2 = (arraySize = (ArraySize)sourceElement).eContainer()) instanceof VarDeclaration) {
                VarDeclaration varDeclaration = (VarDeclaration)eObject2;
                this.setEntryPoint(this.grammarAccess.getSTTypeDeclarationRule());
                return Objects.requireNonNullElse(varDeclaration.getFullTypeName(), "");
            }
            if (sourceElement instanceof Value && (eObject = (value = (Value)sourceElement).eContainer()) instanceof VarDeclaration) {
                VarDeclaration varDeclaration = (VarDeclaration)eObject;
                this.setEntryPoint(this.grammarAccess.getSTInitializerExpressionSourceRule());
                this.setExpectedType(STCoreUtil.getFeatureType((INamedElement)varDeclaration));
                return Objects.requireNonNullElse(value.getValue(), "");
            }
            throw new IOException("Invalid query in ST resource: " + this.uri.query());
        }
        this.setEntryPoint(null);
        this.setIncludeInternalLibraryElement(this.needsInternalLibraryElement(libraryElement, (EObject)libraryElement));
        return this.partitioner.combine(libraryElement);
    }

    protected boolean needsInternalLibraryElement(LibraryElement libraryElement, EObject sourceElement) {
        return sourceElement == libraryElement;
    }

    public void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        if (this.isSavePlainST(options)) {
            super.doSave(outputStream, options);
        } else {
            LibraryElement internalLibraryElement = this.getInternalLibraryElement();
            if (this.getContents().isEmpty() || !this.isIncludeInternalLibraryElement() || internalLibraryElement == null) {
                throw new IOException("The ST core resource must contain at least one element and have an associated library element");
            }
            LibraryElement libraryElement = (LibraryElement)EcoreUtil.copy((EObject)internalLibraryElement);
            this.reconcile(libraryElement, options);
            try {
                FordiacTypeResource typeResource = new FordiacTypeResource(this.uri);
                typeResource.getContents().add((Object)libraryElement);
                typeResource.save(outputStream, options);
            }
            catch (Exception e) {
                throw new IOException("Error saving to library element: " + e.getMessage(), e);
            }
        }
    }

    protected void reconcile(LibraryElement libraryElement, Map<?, ?> options) throws IOException {
        block19: {
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                    super.doSave((OutputStream)stream, options);
                    String text = new String(stream.toByteArray(), this.getEncoding());
                    if (this.uri.hasQuery()) {
                        EObject sourceElement;
                        EObject eObject = sourceElement = this.getSourceElement(libraryElement);
                        Objects.requireNonNull(eObject);
                        EObject eObject2 = eObject;
                        int n = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Attribute.class, ArraySize.class, Value.class}, (Object)eObject2, n)) {
                            case 0: {
                                Attribute attribute = (Attribute)eObject2;
                                attribute.setValue(text);
                                break block19;
                            }
                            case 1: {
                                ArraySize arraySize = (ArraySize)eObject2;
                                arraySize.setValue(text);
                                break block19;
                            }
                            case 2: {
                                Value value = (Value)eObject2;
                                value.setValue(text);
                                break block19;
                            }
                            default: {
                                throw new IOException("Invalid query in ST resource: " + this.uri.query());
                            }
                        }
                    }
                    super.doLoad((InputStream)new LazyStringInputStream(text, this.getEncoding()), null);
                    Optional<STCorePartition> partition = this.partitioner.partition((XtextResource)this);
                    if (partition.isEmpty()) {
                        throw new IOException("Cannot partition source");
                    }
                    this.reconciler.reconcile(libraryElement, partition);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Cannot reconcile source", e);
            }
        }
    }

    @Override
    public void updateInternalLibraryElement() {
        super.updateInternalLibraryElement();
        this.updateExpectedType();
    }

    public void updateExpectedType() {
        Value value;
        EObject eObject;
        EObject sourceElement = this.getSourceElement();
        if (sourceElement instanceof Attribute) {
            Attribute attribute = (Attribute)sourceElement;
            this.setExpectedType(STCoreUtil.getFeatureType((INamedElement)attribute));
        } else if (sourceElement instanceof Value && (eObject = (value = (Value)sourceElement).eContainer()) instanceof VarDeclaration) {
            VarDeclaration varDeclaration = (VarDeclaration)eObject;
            this.setExpectedType(STCoreUtil.getFeatureType((INamedElement)varDeclaration));
        }
    }

    protected boolean isLoadPlainST(Map<?, ?> options, InputStream inputStream) {
        return this.uri.fileExtension() == null || this.fileExtensionProvider.getPrimaryFileExtension().equalsIgnoreCase(this.uri.fileExtension()) || Boolean.TRUE.equals(options.get(OPTION_PLAIN_ST)) || inputStream instanceof LazyStringInputStream;
    }

    protected boolean isSavePlainST(Map<?, ?> options) {
        return this.uri.fileExtension() == null || this.fileExtensionProvider.getPrimaryFileExtension().equalsIgnoreCase(this.uri.fileExtension()) || options != null && Boolean.TRUE.equals(options.get(OPTION_PLAIN_ST));
    }

    protected void handleTypeLoadException(Throwable e) {
        this.getErrors().add((Object)new TypeImportDiagnostic(e.getMessage(), Messages.STCoreResource_TypeLoadError));
    }

    public Map<Object, Object> getDefaultLoadOptions() {
        if (this.defaultLoadOptions == null) {
            this.defaultLoadOptions = new HashMap();
        }
        return this.defaultLoadOptions;
    }

    public EObject getSourceElement() {
        EObject sourceElement = this.getInternalSourceElement();
        if (sourceElement == null && this.uri.hasQuery() && this.resourceSet != null) {
            return this.getSourceElement(STCoreResource.findInternalLibraryElement(this.resourceSet.getResource(this.uri.trimQuery(), true)));
        }
        return sourceElement;
    }

    protected EObject getSourceElement(LibraryElement libraryElement) {
        if (libraryElement != null && this.uri.hasQuery()) {
            Resource resource = libraryElement.eResource();
            String fragment = resource instanceof STCoreResource ? STCoreResource.toInternalFragment(this.uri.query()) : STCoreResource.toExternalFragment(this.uri.query());
            return resource.getEObject(fragment);
        }
        return libraryElement;
    }

    public EObject getInternalSourceElement() {
        if (this.uri.hasQuery()) {
            return this.getEObject(STCoreResource.toInternalFragment(this.uri.query()));
        }
        return this.getInternalLibraryElement();
    }

    public INamedElement getExpectedType() {
        return this.expectedType;
    }

    public void setExpectedType(INamedElement expectedType) {
        this.expectedType = expectedType;
    }

    public INamedElement getExpectedType(STExpression expression) {
        return (INamedElement)this.getCache().get((Object)Tuples.create((Object)EXPECTED_TYPE_CACHE_KEY, (Object)expression), (Resource)this, () -> STCoreUtil.computeExpectedType((STExpression)expression));
    }

    public INamedElement getExpectedType(STInitializerExpression expression) {
        return (INamedElement)this.getCache().get((Object)Tuples.create((Object)EXPECTED_TYPE_CACHE_KEY, (Object)expression), (Resource)this, () -> STCoreUtil.computeExpectedType((STInitializerExpression)expression));
    }
}

