/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.eval;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.fordiac.ide.deployment.data.FBDeploymentData;
import org.eclipse.fordiac.ide.deployment.devResponse.Response;
import org.eclipse.fordiac.ide.deployment.eval.DeploymentEvaluatorConfigurationBuilder;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.DeviceManagementInteractorFactory;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.model.eval.AbstractEvaluator;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public class DeploymentEvaluatorSharedState
implements Closeable {
    public static final String SHARED_STATE_NAME = DeploymentEvaluatorSharedState.class.getName();
    private final Resource resource;
    private final IDeviceManagementInteractor deviceManagementInteractor;

    protected DeploymentEvaluatorSharedState(Resource resource) {
        this.resource = Objects.requireNonNull(resource, "Resource must not be null");
        this.deviceManagementInteractor = Objects.requireNonNull(DeviceManagementInteractorFactory.INSTANCE.getDeviceManagementInteractor(Objects.requireNonNull(resource.getDevice(), "Resource not in device")), "No valid device management interactor for profile " + resource.getDevice().getProfile());
    }

    public static DeploymentEvaluatorSharedState fromContext(TypeLibrary typeLibrary) {
        return (DeploymentEvaluatorSharedState)AbstractEvaluator.getSharedResources().computeIfAbsent(SHARED_STATE_NAME, unused -> new DeploymentEvaluatorSharedState(DeploymentEvaluatorConfigurationBuilder.fromContext(AbstractEvaluator.currentContext(), typeLibrary).build()));
    }

    public void prepare() throws DeploymentException {
        if (!this.deviceManagementInteractor.isConnected()) {
            this.deviceManagementInteractor.connect();
            this.deviceManagementInteractor.createResource(this.resource);
            this.deviceManagementInteractor.startResource(this.resource);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.deviceManagementInteractor.isConnected()) {
                this.deviceManagementInteractor.deleteResource(this.resource.getName());
                this.deviceManagementInteractor.disconnect();
            }
        }
        catch (DeploymentException e) {
            throw new IOException(e);
        }
    }

    public void createFBInstance(FBDeploymentData deploymentData) throws DeploymentException {
        this.deviceManagementInteractor.createFBInstance(deploymentData, this.resource);
    }

    public void startFB(FBDeploymentData deploymentData) throws DeploymentException {
        this.deviceManagementInteractor.startFB(this.resource, deploymentData);
    }

    public void deleteFB(FBDeploymentData deploymentData) throws DeploymentException {
        this.deviceManagementInteractor.deleteFB(this.resource, deploymentData);
    }

    public void addWatch(Resource resource, String name) throws DeploymentException {
        this.deviceManagementInteractor.addWatch(resource, name);
    }

    public void removeWatch(Resource resource, String name) throws DeploymentException {
        this.deviceManagementInteractor.removeWatch(resource, name);
    }

    public Response readWatches() throws DeploymentException {
        return this.deviceManagementInteractor.readWatches();
    }

    public void triggerEvent(Resource resource, String name) throws DeploymentException {
        this.deviceManagementInteractor.triggerEvent(resource, name);
    }

    public void writeFBParameter(String value, FBDeploymentData deploymentData, VarDeclaration varDeclaration) throws DeploymentException {
        this.deviceManagementInteractor.writeFBParameter(this.resource, value, deploymentData, varDeclaration);
    }

    public void writeDeviceParameter(String name, String value) throws DeploymentException {
        this.deviceManagementInteractor.writeDeviceParameter(this.resource.getDevice(), name, value);
    }

    public Resource getResource() {
        return this.resource;
    }

    public IDeviceManagementInteractor getDeviceManagementInteractor() {
        return this.deviceManagementInteractor;
    }
}

