/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.libraryElement.impl;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.fordiac.ide.model.libraryElement.Comment;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerFBNElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.impl.NamedElementAnnotations;

public final class FBNetworkElementAnnotations {
    private static final String NAMED_ELEMENTS_KEY = FBNetworkElementAnnotations.class.getName() + ".NAMED_ELEMENTS";

    public static boolean validateName(FBNetworkElement element, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (FBNetworkElementAnnotations.isErrorMarkerOrComment(element)) {
            return true;
        }
        return NamedElementAnnotations.validateName(element, diagnostics, context) && NamedElementAnnotations.validateDuplicateName(element, diagnostics, context, NAMED_ELEMENTS_KEY);
    }

    static boolean isErrorMarkerOrComment(FBNetworkElement element) {
        return element instanceof ErrorMarkerFBNElement || element instanceof Comment;
    }

    private FBNetworkElementAnnotations() {
        throw new UnsupportedOperationException();
    }

    public static String getQualifiedName(FBNetworkElement element) {
        INamedElement namedContainer = NamedElementAnnotations.getNamedContainer(element);
        if (namedContainer != null && namedContainer.eContainer() != null) {
            return namedContainer.getQualifiedName() + "." + FBNetworkElementAnnotations.getFBNetworkElementName(element);
        }
        return FBNetworkElementAnnotations.getFBNetworkElementName(element);
    }

    private static String getFBNetworkElementName(FBNetworkElement element) {
        if (element.isMapped() && element.getMapping().getTo() == element) {
            return element.getOpposite().getQualifiedName();
        }
        return element.getName();
    }
}

