/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.elk.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.elk.FordiacLayoutData;
import org.eclipse.gef.commands.Command;

public class ConnectionLayoutCommand
extends Command {
    private final List<FordiacLayoutData.ConnectionLayoutData> newRoutingData;
    private final List<FordiacLayoutData.ConnectionLayoutData> oldRoutingData;

    public ConnectionLayoutCommand(FordiacLayoutData data) {
        this.newRoutingData = data.getConnectionPoints();
        this.oldRoutingData = new ArrayList<FordiacLayoutData.ConnectionLayoutData>(this.newRoutingData.size());
    }

    public void execute() {
        ConnectionLayoutCommand.saveRoutingDataForUndo(this.newRoutingData, this.oldRoutingData);
        ConnectionLayoutCommand.setRoutingData(this.newRoutingData);
    }

    public void redo() {
        ConnectionLayoutCommand.setRoutingData(this.newRoutingData);
    }

    public void undo() {
        ConnectionLayoutCommand.setRoutingData(this.oldRoutingData);
    }

    private static void setRoutingData(List<FordiacLayoutData.ConnectionLayoutData> routingData) {
        routingData.forEach(rd -> rd.con().setRoutingData(rd.routingData()));
    }

    private static void saveRoutingDataForUndo(List<FordiacLayoutData.ConnectionLayoutData> newRoutingData, List<FordiacLayoutData.ConnectionLayoutData> oldRoutingData) {
        newRoutingData.forEach(cd -> {
            boolean bl = oldRoutingData.add(new FordiacLayoutData.ConnectionLayoutData(cd.con(), cd.con().getRoutingData()));
        });
    }
}

