/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionAlgorithmEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionOutputEventEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECTransitionEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.ui.IWorkbenchPart;

public class DeleteECCAction
extends DeleteAction {
    public DeleteECCAction(IWorkbenchPart part) {
        super(part);
    }

    public Command createDeleteCommand(List<EditPart> objects) {
        if (objects.isEmpty()) {
            return null;
        }
        if (!(objects.get(0) instanceof EditPart)) {
            return null;
        }
        return super.createDeleteCommand(DeleteECCAction.getDeleteList(objects));
    }

    private static List<EditPart> getDeleteList(List<EditPart> objects) {
        ArrayList<EditPart> list = new ArrayList<EditPart>();
        for (EditPart ep : objects) {
            if (ep instanceof ECTransitionEditPart) {
                list.add(0, ep);
                continue;
            }
            if (ep instanceof ECActionAlgorithmEditPart) {
                ECActionAlgorithmEditPart ecActionAlgEP = (ECActionAlgorithmEditPart)ep;
                if (DeleteECCAction.stateContainedInDeleteList(objects, ecActionAlgEP.getCastedModel().getAction().getECState())) continue;
                list.add((EditPart)ecActionAlgEP);
                continue;
            }
            if (ep instanceof ECActionOutputEventEditPart) {
                ECActionOutputEventEditPart ecActionEventEP = (ECActionOutputEventEditPart)ep;
                if (DeleteECCAction.stateContainedInDeleteList(objects, ecActionEventEP.getCastedModel().getAction().getECState())) continue;
                list.add((EditPart)ecActionEventEP);
                continue;
            }
            list.add(ep);
        }
        return list;
    }

    private static boolean stateContainedInDeleteList(List<EditPart> objects, ECState eState) {
        for (EditPart ep : objects) {
            if (!ep.getModel().equals(eState)) continue;
            return true;
        }
        return false;
    }
}

