/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.gef.commands.Command;

public class DeleteAlgorithmCommand
extends Command {
    private final BasicFBType fbType;
    private final Algorithm algorithm;
    private final List<ECAction> actions = new ArrayList<ECAction>();

    public DeleteAlgorithmCommand(BasicFBType fbType, Algorithm algorithm) {
        this.fbType = fbType;
        this.algorithm = algorithm;
    }

    public void execute() {
        for (ECState state : this.fbType.getECC().getECState()) {
            for (ECAction ecAction : state.getECAction()) {
                if (ecAction.getAlgorithm() == null || !ecAction.getAlgorithm().equals(this.algorithm)) continue;
                this.actions.add(ecAction);
            }
        }
        this.redo();
    }

    public void undo() {
        for (ECAction action : this.actions) {
            action.setAlgorithm(this.algorithm);
        }
        this.fbType.getCallables().add((Object)this.algorithm);
    }

    public void redo() {
        for (ECAction action : this.actions) {
            action.setAlgorithm(null);
        }
        this.fbType.getCallables().remove((Object)this.algorithm);
    }
}

