/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.gef.editparts.AbstractCombinedCellEditor;
import org.eclipse.fordiac.ide.gef.editparts.LabelCellEditorLocator;
import org.eclipse.fordiac.ide.gef.editparts.TextDirectEditManager;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractDirectEditManager<T>
extends TextDirectEditManager {
    private static final Insets BORDER_INSETS = new Insets(0, 0, 0, 0);
    private static final AbstractBorder BORDER = new AbstractBorder(){

        public Insets getInsets(IFigure figure) {
            return BORDER_INSETS;
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
        }
    };
    private final T element;

    protected AbstractDirectEditManager(GraphicalEditPart source, T element, Label label, ZoomManager zoomManager, FigureCanvas fc) {
        super(source, new LabelCellEditorLocator(label, zoomManager, fc));
        this.element = element;
    }

    @Override
    protected void initCellEditor() {
        super.initCellEditor();
        if (this.element != null) {
            this.getCellEditor().setValue(this.element);
            CCombo combo = this.getComboBox();
            combo.addModifyListener(e -> this.setDirty(true));
            Text text = this.getText();
            text.addModifyListener(e -> this.setDirty(true));
        }
    }

    public LabelCellEditorLocator getLocator() {
        return (LabelCellEditorLocator)super.getLocator();
    }

    protected AbstractCombinedCellEditor<T> getCellEditor() {
        return (AbstractCombinedCellEditor)super.getCellEditor();
    }

    public void updateRefPosition(Point refPoint) {
        this.getLocator().setRefPoint(refPoint);
    }

    protected IFigure getCellEditorFrame() {
        IFigure cellEditorFrame = super.getCellEditorFrame();
        cellEditorFrame.setBorder((Border)BORDER);
        return cellEditorFrame;
    }

    public CCombo getComboBox() {
        if (this.getCellEditor() != null) {
            return this.getCellEditor().getCCombo();
        }
        return null;
    }

    public Text getText() {
        if (this.getCellEditor() != null) {
            return this.getCellEditor().getText();
        }
        return null;
    }
}

