/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.gef.editparts.AbstractConnectableEditPart;
import org.eclipse.fordiac.ide.gef.editparts.LabelDirectEditManager;
import org.eclipse.fordiac.ide.gef.policies.INamedElementRenameEditPolicy;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractDirectEditableEditPart
extends AbstractConnectableEditPart {
    private final Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            Object feature = notification.getFeature();
            if (LibraryElementPackage.eINSTANCE.getINamedElement_Name().equals(feature)) {
                AbstractDirectEditableEditPart.this.refreshName();
            }
            super.notifyChanged(notification);
        }
    };

    protected Adapter getNameAdapter() {
        return this.adapter;
    }

    public void refreshName() {
        this.getNameLabel().setText(this.getINamedElement().getName());
    }

    public abstract INamedElement getINamedElement();

    public void activate() {
        super.activate();
        if (this.getINamedElement() != null) {
            this.getINamedElement().eAdapters().add((Object)this.adapter);
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.getINamedElement() != null) {
            this.getINamedElement().eAdapters().remove((Object)this.adapter);
        }
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        if (this.isDirectEditable()) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new INamedElementRenameEditPolicy());
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" && this.isDirectEditable()) {
            this.performDirectEdit();
        } else {
            super.performRequest(request);
        }
    }

    protected DirectEditManager createDirectEditManager() {
        return new LabelDirectEditManager((GraphicalEditPart)this, this.getNameLabel());
    }

    public abstract Label getNameLabel();

    public void performDirectEdit() {
        this.createDirectEditManager().show();
    }

    public static void executeCommand(Command cmd) {
        GraphicalViewer viewer;
        IEditorPart currentActiveEditor = EditorUtils.getCurrentActiveEditor();
        if (currentActiveEditor != null && (viewer = (GraphicalViewer)currentActiveEditor.getAdapter(GraphicalViewer.class)) != null) {
            viewer.getEditDomain().getCommandStack().execute(cmd);
            return;
        }
        cmd.execute();
    }

    public boolean isDirectEditable() {
        return true;
    }
}

