/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.Changes;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.UndoEdit;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class ProviderDocumentUndoChange
extends Change {
    private final String name;
    private final IFileEditorInput editorInput;
    private final IDocumentProvider documentProvider;
    private final UndoEdit undoEdit;
    private final boolean doSave;

    public ProviderDocumentUndoChange(String name, IFileEditorInput editorInput, IDocumentProvider documentProvider, UndoEdit undoEdit, boolean doSave) {
        this.name = name;
        this.editorInput = editorInput;
        this.documentProvider = documentProvider;
        this.undoEdit = undoEdit;
        this.doSave = doSave;
    }

    public String getName() {
        return this.name;
    }

    public Object getModifiedElement() {
        return this.editorInput.getFile();
    }

    public Object[] getAffectedObjects() {
        return new Object[]{this.editorInput.getFile()};
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        IDocument document = null;
        try {
            document = this.acquireDocument();
            UndoEdit undo = this.performEdits(document);
            this.commit(document, pm);
            Change change = this.createUndoChange(undo);
            return change;
        }
        catch (BadLocationException e) {
            throw Changes.asCoreException((BadLocationException)e);
        }
        catch (MalformedTreeException e) {
            throw Changes.asCoreException((MalformedTreeException)e);
        }
        finally {
            this.releaseDocument();
        }
    }

    protected UndoEdit performEdits(IDocument document) throws BadLocationException, MalformedTreeException {
        DocumentRewriteSession session = null;
        try {
            if (document instanceof IDocumentExtension4) {
                session = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
            }
            UndoEdit undoEdit = this.undoEdit.apply(document);
            return undoEdit;
        }
        finally {
            if (session != null) {
                ((IDocumentExtension4)document).stopRewriteSession(session);
            }
        }
    }

    protected IDocument acquireDocument() throws CoreException {
        this.documentProvider.connect((Object)this.editorInput);
        IDocument document = this.documentProvider.getDocument((Object)this.editorInput);
        if (document == null) {
            this.documentProvider.disconnect((Object)this.editorInput);
        }
        return document;
    }

    protected void commit(IDocument document, IProgressMonitor pm) throws CoreException {
        if (this.doSave) {
            this.documentProvider.saveDocument(pm, (Object)this.editorInput, document, false);
        }
    }

    protected void releaseDocument() {
        this.documentProvider.disconnect((Object)this.editorInput);
    }

    protected Change createUndoChange(UndoEdit edit) {
        return new ProviderDocumentUndoChange(this.name, this.editorInput, this.documentProvider, edit, this.doSave);
    }
}

